package edu.cornell.cs.cs4120.xth.xic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import edu.cornell.cs.cs4120.xth.PDFReporter;

public class XicPDFReporter extends PDFReporter {

    protected Pattern pattern =
            Pattern.compile("group_of_((\\p{Lower}+\\d+_)+(\\p{Lower}+\\d+))_(\\d+\\.|_[^/]+)");
    protected int anonCounter;
    protected Map<String, String> anonymizer = new HashMap<>();

    public XicPDFReporter(String filename) {
        super(filename);
    }

    @Override
    public String anonymizedName(String name) {
        Matcher matcher = pattern.matcher(name);
        Set<String> groupNames = new HashSet<>();
        while (matcher.find()) {
            String groupName = matcher.group(1);
            if (!anonymizer.containsKey(groupName)) {
                String anonymizedGroupName =
                        "anonymous" + String.format("%02d", ++anonCounter);
                anonymizer.put(groupName, anonymizedGroupName);
            }
            groupNames.add(groupName);
        }
        for (String groupName : groupNames)
            name = name.replaceAll(groupName, anonymizer.get(groupName));
        return name;
    }
}
