package edu.cornell.cs.cs4120.xth;

/**
 *
 */
public interface Test {
    String getName();

    /**
     * A string that uniquely identifies this test.
     * @return
     */
    String getUniqueId();

    String getDescription();

    boolean success();

    String getNotice();

    String getFailureMessage();

    boolean run();

    boolean shouldExecute(TestResult tr);

    boolean haltOnFailure();

    void setOutputController(OutputController output);

    void setPDFReporter(PDFReporter pdfReporter);

    TestResult getTestResult();

    void setTestResult(TestResult tr);

    int getTotalTestCount();

    int getExecutedTestCount();

    int getSuccessfulTestCount();

    int[] displayTestResult(OutputController outCtrl);

}
