package edu.cornell.cs.cs4120.xth;

import java.io.PrintStream;

/**
 *
 */
public class StdOutputController extends OutputController {
    public StdOutputController(PrintStream out) {
        super(out);
    }

    @Override
    protected void startScriptTestSuite(ScriptTestSuite sts) {
        println("Test script: " + sts.getName());
        beginBlock();
    }

    @Override
    protected void finishScriptTestSuite(ScriptTestSuite sts) {
        endBlock();
        String notice = sts.getNotice();
        if (notice != null) println(notice);

        if (!sts.success() && sts.getFailureMessage() != null)
            println(sts.getFailureMessage());

        println(sts.getName() + ": " + sts.getSuccessfulTestCount() + " out of "
                + sts.getExecutedTestCount() + " tests succeeded.");
    }

    @Override
    protected void startSourceFileTestCollection(
            SourceFileTestCollection sftc) {
        println("Test collection: " + sftc.getName());
        beginBlock();
    }

    @Override
    protected void finishSourceFileTestCollection(
            SourceFileTestCollection sftc) {
        endBlock();
        String notice = sftc.getNotice();
        if (notice != null) println(notice);

        if (!sftc.success() && sftc.getFailureMessage() != null)
            println(sftc.getFailureMessage());

        println(sftc.getSummary());
    }

    @Override
    protected void startSourceFileTest(SourceFileTest sft) {
        print(sft.getName() + ": ");
        beginBlock();
    }

    @Override
    protected void finishSourceFileTest(SourceFileTest sft) {
        endBlock();
        String notice = sft.getNotice();
        if (notice != null) print("[" + notice + "] ");

        if (sft.success())
            println("OK");
        else {
            String msg = sft.getFailureMessage();
            if (msg != null)
                println(msg);
            else println("Failed (no message)");
        }
        if (!Main.options.suppressCompilerOutputs) {
            String stdout = sft.getCompilerStdout();
            if (stdout != null) {
                println("[Compiler's standard output:");
                print(stdout);
                println("]");
            }
            String stderr = sft.getCompilerStderr();
            if (stderr != null) {
                println("[Compiler's standard error:");
                print(stderr);
                println("]");
            }
        }
    }

    @Override
    protected void startBuildTest(BuildTest b) {
        print(b.getName() + ": ");
        beginBlock();
    }

    @Override
    protected void finishBuildTest(BuildTest b) {
        endBlock();
        String notice = b.getNotice();
        if (notice != null) println(notice);

        if (b.success())
            println("OK");
        else if (b.getFailureMessage() != null)
            println(b.getFailureMessage());
        else println("Failed (no message)");
    }

    @Override
    public void printNoTestResults(String suiteName) {
        println("No test results for " + suiteName);
    }

    @Override
    public void printTestSuiteHeader(TestSuiteResult tsr) {
        print("Test suite \"" + tsr.testName + "\"");
        println("    Last run: " + getDateDisplay(tsr.dateTestRun));
        println("Contains tests:");
        beginBlock();
    }

    @Override
    public void printTestSuiteFooter(int total, int grandTotal, int lastSuccess,
            int neverRun, int neverSuccess) {
        endBlock();
        print("Total tests displayed: " + total);
        if (total != grandTotal)
            print(" (out of " + grandTotal + " in script)");
        println();
        println("   Succeeded last run: " + lastSuccess);
        println("   Never run         : " + neverRun);
        println("   Never succeeded   : " + neverSuccess);
    }

    private static final int TEST_NAME_COLUMN_WIDTH = 30;

    @Override
    public void displayTestResults(TestResult tr, String testName) {
        StringBuffer sb = new StringBuffer();
        sb.append(testName);
        while (sb.length() < TEST_NAME_COLUMN_WIDTH)
            sb.append(' ');
        sb.append(" run ");
        sb.append(getDateDisplay(tr == null ? null : tr.dateTestRun));
        sb.append("; success ");
        sb.append(getDateDisplay(tr == null ? null : tr.dateLastSuccess));
        println(sb.toString());
    }

    @Override
    public void warning(String w) {
        println("Warning: " + w);
    }
}
