package edu.cornell.cs.cs4120.xth;

import java.io.PrintStream;

/**
 *
 */
public class QuietOutputController extends StdOutputController {
    private final boolean showStartScript;
    private final boolean showFinishScript;
    private final boolean showScriptProgress;
    private final boolean showStartFile;
    private final boolean showFinishFile;
    private int count = 0;

    private static final char PROGRESS_PASS_CHAR = '.';
    private static final char PROGRESS_FAIL_CHAR = '!';
    private static final int PROGRESS_LIMIT = 60;

    public QuietOutputController(PrintStream out, boolean showStartScript,
            boolean showFinishScript, boolean showStartFile,
            boolean showFinishFile, boolean showScriptProgress) {
        super(out);
        this.showStartScript = showStartScript;
        this.showFinishScript = showFinishScript;
        this.showScriptProgress = showScriptProgress;
        this.showStartFile = showStartFile;
        this.showFinishFile = showFinishFile;
    }

    @Override
    protected void startScriptTestSuite(ScriptTestSuite sts) {
        if (showStartScript)
            super.startScriptTestSuite(sts);
        else beginBlock();
    }

    @Override
    protected void finishScriptTestSuite(ScriptTestSuite sts) {
        if (showScriptProgress && !printIndent) println();
        if (showFinishScript)
            super.finishScriptTestSuite(sts);
        else endBlock();
    }

    @Override
    protected void startSourceFileTestCollection(
            SourceFileTestCollection sftc) {
        if (showStartScript)
            super.startSourceFileTestCollection(sftc);
        else beginBlock();
    }

    @Override
    protected void finishSourceFileTestCollection(
            SourceFileTestCollection sftc) {
        if (showScriptProgress && !printIndent) println();
        if (showFinishScript)
            super.finishSourceFileTestCollection(sftc);
        else endBlock();
    }

    @Override
    protected void startSourceFileTest(SourceFileTest sft) {
        if (showStartFile)
            super.startSourceFileTest(sft);
        else beginBlock();
    }

    @Override
    protected void finishSourceFileTest(SourceFileTest sft) {
        if (showFinishFile)
            super.finishSourceFileTest(sft);
        else {
            endBlock();
            if (showScriptProgress) {
                print(sft.success() ? PROGRESS_PASS_CHAR : PROGRESS_FAIL_CHAR);
                if (++count >= PROGRESS_LIMIT - indent) {
                    println();
                    count = 0;
                }
            }
        }
    }

    @Override
    protected void startBuildTest(BuildTest b) {
        if (showStartFile)
            super.startBuildTest(b);
        else beginBlock();
    }

    @Override
    protected void finishBuildTest(BuildTest b) {
        if (showFinishFile)
            super.finishBuildTest(b);
        else endBlock();
    }
}
