package edu.cornell.cs.cs4120.xth;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

import edu.cornell.cs.cs4120.xth.xic.XicPDFReporter;
import edu.cornell.cs.cs4120.xth.xic.XicTestFactory;

/**
 *  Main program for the xic Test Harness
 */
public class Main {
    public static void main(String[] args) {
        boolean okay = new Main().start(args);
        if (options.nonzeroExitCodeOnFailedTests && !okay) System.exit(1);
    }

    public static Options options;

    public boolean start(String[] args) {
//        System.setProperty("line.separator", "\n");
        options = new Options();
        try {
            options.parseCommandLine(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }

        if (options.inputFilenames.isEmpty()) {
            System.err.println("Need at least one script file.");
            System.exit(1);
        }

        // Steffen's hack: if no testpath is provided, use folder containing
        // test script by default.
        if (options.testpath == null) {
            String scriptFile = options.inputFilenames.get(0);
            Path scriptPath = Paths.get(scriptFile);
            options.testpath =
                    scriptPath.toAbsolutePath().getParent().toString();
            if (!options.testpath.endsWith(File.separator))
                options.testpath += File.separator;
            System.out.println("No testpath specified. Using \""
                    + options.testpath + "\".");
        }
        else {
            System.out.println("Testpath \"" + options.testpath
                    + "\" specified.");
        }

        OutputController outCtrl = createOutputController(options);

        // TODO
        TestFactory tf = new XicTestFactory();
        PDFReporter pdfReporter = null;
        if (options.pdffilename != null)
            pdfReporter = new XicPDFReporter(options.pdffilename);
        boolean okay = true;
        for (String filename : options.inputFilenames) {
            ScriptTestSuite t = new ScriptTestSuite(tf, filename);
            t.setOutputController(outCtrl);
            t.setPDFReporter(pdfReporter);
            if (options.showResultsOnly)
                t.displayTestResult(outCtrl);
            else okay = okay && t.run();
        }
        if (pdfReporter != null) pdfReporter.flush();
        return okay;
    }

    protected OutputController createOutputController(Options options) {
        switch (options.verbosity) {
        // More output controllers should be written, for varying degrees
        // of detail.
        case 0:
            return new SilentOutputController(System.out);
        case 1:
            return new QuietOutputController(System.out,
                                             false,
                                             true,
                                             false,
                                             false,
                                             false);
        case 2:
            return new QuietOutputController(System.out,
                                             false,
                                             true,
                                             false,
                                             false,
                                             true);
        case 3:
            return new QuietOutputController(System.out,
                                             true,
                                             true,
                                             false,
                                             false,
                                             true);
//        case 8:
//            return new VerboseOutputController(System.out, false);
//        case 9:
//            return new VerboseOutputController(System.out, true);

        default:
            return new StdOutputController(System.out);
        }
    }

}
