package edu.cornell.cs.cs4120.xth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 */
public class ExpectedFailure {
    public enum Kind {
        UNKNOWN, LEXICAL, SYNTAX, SEMANTIC
    }

    public ExpectedFailure(Kind kind) {
        this(kind, null);
    }

    public ExpectedFailure(String errMsg) {
        this(null, errMsg);
    }

    public ExpectedFailure(Kind kind, String errMsg) {
        this.kind = kind;
        errMsgRegExp = errMsg;
    }

    final Kind kind;
    final String errMsgRegExp;

//    public boolean matches(ErrorInfo e) {
//        if (kind != null && kind.intValue() != e.getErrorKind()) return false;
//        if (errMsgRegExp != null) {
//            Matcher m = Pattern.compile(errMsgRegExp).matcher(e.getMessage());
//            return m.find();
//        }
//        return true;
//    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ExpectedFailure) {
            ExpectedFailure that = (ExpectedFailure) o;
            return (that.kind == kind
                    || that.kind != null && that.kind.equals(kind))
                    && (that.errMsgRegExp == errMsgRegExp
                            || that.errMsgRegExp != null
                                    && that.errMsgRegExp.equals(errMsgRegExp));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (errMsgRegExp == null ? -323 : errMsgRegExp.hashCode())
                + (kind == null ? 41 : kind.hashCode());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (kind != null)
            sb.append(kind);
        else sb.append("error");
        if (errMsgRegExp != null) {
            sb.append(" matching the regular expression '");
            sb.append(errMsgRegExp);
            sb.append('\'');
        }
        return sb.toString();
    }
}
