#!/bin/bash
set -x
set -e

export DEBIAN_FRONTEND="noninteractive"

# basics - do not modify!
apt-get -qq update
apt-get -qq install \
  software-properties-common \
  python-software-properties \
  pkg-config \
  wget \
  unzip \
  zip \
  dpkg \
  m4 \
  libgmp-dev \
  nano vim \
  x11-apps

# Java 9
add-apt-repository ppa:webupd8team/java
apt-get -qq update
echo debconf shared/accepted-oracle-license-v1-1 select true | debconf-set-selections
echo debconf shared/accepted-oracle-license-v1-1 seen true | debconf-set-selections
apt-get -qq install oracle-java9-installer &>/dev/null
apt-get -qq install oracle-java9-set-default &>/dev/null

# Ant
apt-get -qq install ant

# Maven
apt-get -qq install maven

# Qt
apt-get -qq install cmake libqt4-dev libqt4-designer libqt4-opengl libqt4-svg libqtgui4 libqtwebkit4 libstdc++-4.8-dev g++

# Gradle
GRADLE=gradle-4.5
GRADLEZIP=gradle-4.5-bin.zip
wget -nv -N https://services.gradle.org/distributions/$GRADLEZIP
unzip -d /opt/ $GRADLEZIP
ln -s /opt/$GRADLE/bin/gradle /usr/local/bin/
rm $GRADLEZIP

# Scala
SCALA=scala-2.12.4.deb
wget -nv -N www.scala-lang.org/files/archive/$SCALA
dpkg -i $SCALA &>/dev/null
apt-get -qq update  &>/dev/null
apt-get -qq install scala 2>/dev/null
rm "$SCALA"

# Scala sbt
echo "deb https://dl.bintray.com/sbt/debian /" | tee -a /etc/apt/sources.list.d/sbt.list
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 2EE0EA64E40A89B84B2DF73499E82A75642AC823
apt-get -qq update
apt-get -qq install sbt
sbt update

# OCaml
apt-get -qq install libncurses5-dev

mkdir ocaml_debs
cd ocaml_debs
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml_4.05.0-10_amd64.deb
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml-base_4.05.0-10_amd64.deb
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml-base-nox_4.05.0-10_amd64.deb
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml-nox_4.05.0-10_amd64.deb
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml-interp_4.05.0-10_amd64.deb
wget -nv -N http://ftp.us.debian.org/debian/pool/main/o/ocaml/ocaml-compiler-libs_4.05.0-10_amd64.deb
dpkg -i *.deb
cd ..
rm -r ocaml_debs

OPAM_VER=1.2.2
OPAM="opam-$OPAM_VER-x86_64-Linux"
wget -nv -N "https://github.com/ocaml/opam/releases/download/$OPAM_VER/$OPAM"
mv "$OPAM" /usr/local/bin/opam
chmod 755 /usr/local/bin/opam

# Haskell
HASKELLTGZ=haskell-platform-8.2.2-unknown-posix--full-x86_64.tar.gz
wget -nv -N https://haskell.org/platform/download/8.2.2/$HASKELLTGZ
mkdir haskell_extract
tar xf $HASKELLTGZ -C haskell_extract
cd haskell_extract
./install-haskell-platform.sh
cd ..
rm -r haskell_extract
rm "$HASKELLTGZ"

# for backwards compatability
chown -R vagrant $HOME

# see user-bootstrap.sh for more non-sudo bootstrapping
