#!/bin/bash
set -x
set -e

export DEBIAN_FRONTEND="noninteractive"

# basics - do not modify!
apt-get -qq update &>/dev/null
apt-get -qq install \
  software-properties-common \
  python-software-properties \
  pkg-config \
  wget \
  dpkg \
  m4 \
  nano vim \
  x11-apps \
  &>/dev/null

# Java 8
add-apt-repository ppa:webupd8team/java &>/dev/null
apt-get -qq update &>/dev/null
echo debconf shared/accepted-oracle-license-v1-1 select true | debconf-set-selections
echo debconf shared/accepted-oracle-license-v1-1 seen true | debconf-set-selections
apt-get -qq install oracle-java8-installer 2>/dev/null
apt-get -qq install oracle-java8-set-default 2>/dev/null

# Ant
apt-get -qq install ant 2>/dev/null

# Maven
apt-get -qq install maven 2>/dev/null

# Qt
apt-get -qq install cmake libqt4-dev libqt4-gui libstdc++-4.8-dev g++ 2>/dev/null

# Scala
SCALA=scala-2.11.7.deb
wget -nv -N www.scala-lang.org/files/archive/$SCALA
dpkg -i $SCALA &>/dev/null
apt-get -qq update  &>/dev/null
apt-get -qq install scala 2>/dev/null

# Scala sbt
echo "deb https://dl.bintray.com/sbt/debian /" | tee -a /etc/apt/sources.list.d/sbt.list
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 642AC823 &>/dev/null
apt-get -qq update &>/dev/null
apt-get -qq install sbt 2>/dev/null
sbt update

# OCaml
add-apt-repository ppa:avsm/ppa &>/dev/null
apt-get -qq update &>/dev/null
apt-get -qq install ocaml ocaml-native-compilers opam 2>/dev/null


# for backwards compatability
chown -R vagrant $HOME

# see user-bootstrap.sh for more non-sudo bootstrapping
