import java.util.Map;
import java.util.IdentityHashMap;

public abstract class XiType {
	private static XiType mBool = new XiBool();
	public static XiType getBool() { return mBool; }
	private static XiType mInt = new XiInt();
	public static XiType getInt() { return mInt; }
	private static Map<XiType,XiType> mArrays = new IdentityHashMap<XiType,XiType>();
	public static XiType getArray(XiType elemType) {
		XiType array = mArrays.get(elemType);
		if (array == null) {
			array = new XiArray(elemType);
			mArrays.put(elemType, array);
		}
		return array;
	}

	public boolean equals(Object that) { return equals((XiType)that); }
	public boolean equals(XiType that) { return this == that; }
	public boolean isSubtypeOf(XiType that) { return equals(that); }

	public boolean isBool() { return false; }
	public boolean isInt() { return false; }
	public boolean isArray() { return false; }
	public XiType getArrayArgument() throws NoSuchTypeException {
		throw new NoSuchTypeException();
	}
}

class XiBool extends XiType {
	public boolean isBool() { return true; }
}

class XiInt extends XiType {
	public boolean isInt() { return true; }
}

class XiArray extends XiType {
	private XiType mElemType;
	public XiArray(XiType elemType) { mElemType = elemType; }
	public boolean isArray() { return true; }
	public XiType getArrayArgument() throws NoSuchTypeException {
		return mElemType;
	}
}