parser grammar XiParser;
options { tokenVocab = XiLexer; }

type returns [XiType xi]
     : BOOL { $xi = XiType.getBool(); }
     | INT { $xi = XiType.getInt(); }
     | t=type LBRACKET RBRACKET { $xi = XiType.getArray($t.xi); };
test : expr;
expr returns [XiExpression xi]
     : INTEGER { $xi = new XiInteger($INTEGER.int); }
     | STRING { $xi = new XiString($STRING.text); }
     | TRUE { $xi = new XiBoolean(true); }
     | FALSE { $xi = new XiBoolean(false); }
     | ID { $xi = new XiVariable($ID.text); }
     | ID LPAREN es=exprs RPAREN { $xi = new XiFunctionCall($ID.text, $es.xi); }
     | LENGTH LPAREN e=expr RPAREN { $xi = new XiArrayLength($e.xi); }
     | t=type LBRACKET es=exprs RBRACKET { $xi = new XiNewArray($t.xi, $es.xi);}
     | a=expr LBRACKET i=expr RBRACKET { $xi = new XiArrayAccess($a.xi, $i.xi);}
     | op=(DASH | BANG) e=expr
       { $xi = $op.type == DASH ? new XiNegative($e.xi) : new XiNegate($e.xi); }
     | l=expr op=(STAR | SLASH | PERCENT) r=expr
       { $xi = $op.type == STAR
               ? new XiMultiply($l.xi, $r.xi)
               : $op.type == SLASH
               ? new XiDivide($l.xi, $r.xi)
               : new XiMod($l.xi, $r.xi); }
     | l=expr (PLUS | DASH) r=expr
       { $xi = $op.type == PLUS
             ? new XiAdd($l.xi, $r.xi)
             : new XiSubtract($l.xi, $r.xi); }
     | l=expr
       (op=LANGLE | op=LANGLE eq=EQUAL | op=RANGLE | op=RANGLE eq=EQUAL)
       r=expr
       { XiExpression l = $op.type == LANGLE ? $l.xi : $r.xi;
         XiExpression r = $op.type == LANGLE ? $r.xi : $l.xi;
         $xi = $eq == null ? new XiLessStrict(l, r) : new XiLessEqual(l, r); }
     | l=expr (op=EQUAL EQUAL | op=BANG EQUAL) r=expr
       { $xi = new XiEquals($l.xi, $r.xi);
         if ($op.type == BANG) $xi = new XiNegate($xi); }
     | l=expr AMPERSAND r=expr { $xi = new XiAnd($l.xi, $r.xi); }
     | l=expr PIPE r=expr  { $xi = new XiOr($l.xi, $r.xi); };
exprs returns [List<XiExpression> xi] : { $xi = new ArrayList<XiExpression>(); }
                                        (e=expr { $xi.add($e.xi); }
                                         (COMMA e=expr { $xi.add($e.xi); })*
                                        )?;
fundef : ID LPAREN paramnames RPAREN funtype statement;
paramnames : (ID COLON type (COMMA ID COLON type)*)?;
funtype : (COLON type (COMMA type)*);
statement : (lvalues EQUAL)? expr SEMICOLON
          | RETURN (LPAREN expr (COMMA expr)* RPAREN) SEMICOLON
          | WHILE LPAREN expr RPAREN statement
          | IF LPAREN expr RPAREN statement (ELSE statement)?
          | LBRACE statement* RBRACE
          | BREAK SEMICOLON;
lvalues : lvalue (COMMA lvalues)*;
lvalue : ID (COLON type)?
       | expr LBRACKET expr RBRACKET;