import java.util.Collection;

public class XiNewArray extends XiExpression {
	private XiType mType;
	private Collection<? extends XiExpression> mElements;
	public XiNewArray(XiType type, Collection<? extends XiExpression> elems) {
		mType = type;
		mElements = elems;
	}
	protected XiType calculateType(XiContext context) throws NoSuchTypeException {
		for (XiExpression elem : mElements)
			if (!elem.getType(context).isSubtypeOf(mType))
				throw new NoSuchTypeException();
		return XiType.getArray(mType);
	}
}