import java.util.Collection;
import java.util.List;
import java.util.ArrayList;

public class XiFunctionCall extends XiExpression {
	private String mName;
	private Collection<? extends XiExpression> mArguments;
	public XiFunctionCall(String name, Collection<? extends XiExpression> args) {
		mName = name;
		mArguments = args;
	}
	protected XiType calculateType(XiContext context) throws NoSuchTypeException {
		XiFunction function = context.getFunction(mName);
		if (function == null)
			throw new NoSuchTypeException();
		List<XiType> types = new ArrayList<XiType>(mArguments.size());
		for (XiExpression arg : mArguments)
			types.add(arg.getType(context));
		Collection<? extends XiType> returns = function.getTypes(types);
		if (returns.size() != 1)
			throw new NoSuchTypeException();
		return returns.iterator().next();
	}
}