#!/bin/sh
#
# This script outputs the appropriate ABI tweak environmental variables
# based on the current system
#
# Override to force -m32 if autodetection fails
ABI_FLAG=
CPU=`uname -m`
OS=`uname`
if [ "$OS" != Darwin ]; then
    OS=`uname -o`
fi
if [ $CPU = x86_64 ]; then
    ABI_FLAG=-m32
fi

# -mno-cygwin uses MingW-style build (cygming)
# The -Wa is kind of overkill; it's there to help the example determine
# whether it needs to use _printf or printf
if [ $OS = Cygwin ]; then
    ABI_FLAG="$ABI_FLAG -mno-cygwin -Wa,--defsym -Wa,win32=1"
fi

echo $ABI_FLAG
