/**
 Some exports to help write I9 or IX bindings
*/
#ifndef LIBI9_H
#define LIBI9_H

#ifdef __cplusplus
#define I9_EXPORT extern "C"
#else
#define I9_EXPORT
#endif

#if !defined(__CYGWIN__) && !defined(__APPLE__) && !defined(__MINGW32__)
#define I9(x) _I ## x
#else
#define I9(x) I ## x
/* On Cygwin/Windows (and apparently OS X) the compiler adds _ itself to
   everything; so we don't need one of our own */
#endif

// Main allocation hook
I9_EXPORT int* I9(_alloc_i)(int size);

// Registers a finalizer for a given object
typedef void Finalizer(void*, void*);
I9_EXPORT void i9_registerFinalizer(void* object, Finalizer* fin);


#endif
// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on;
