/**
 Interface to the I9 runtime
*/
typedef struct convResult {
    int num;
    int ok;
} convResult;

void _IparseInt_t2ibai(convResult* retOut, const int* str);
int* _Ireadln_ai(void);
int* _IunparseInt_aii(int);
int  _Ieof_b(void);
void _Iprintln_pai(const int*);
void _Iprint_pai(const int*);

/**
 Test program
*/
int factorial(int i) {
    if (i <= 1)
        return 1;
    else
        return i * factorial(i-1);
}

void _Imain_paai(int** arg) {
    const int prompt[] = { 7, 'N', 'u', 'm', 'b', 'e', 'r', '?' };
    const int fact[]   = { 5, '!', ' ', 'i', 's', ' '};
    const int empty[] =  { 0 };
    int* input, *output;
    convResult result;

    while (!_Ieof_b()) {
        _Iprintln_pai(prompt + 1);
        input = _Ireadln_ai();

        // Convert to integer
        _IparseInt_t2ibai(&result, input);

        if (result.ok) {
            int val = factorial(result.num);

            output  = _IunparseInt_aii(result.num);
            _Iprint_pai(output);
            _Iprint_pai(fact + 1);
            output  = _IunparseInt_aii(val);
            _Iprint_pai(output);
            _Iprintln_pai(empty + 1);
        }
    }
}
