// A simple bouncing ball demo..

#include <bindqt.h>
#include <libi9.h>

// Dimension of the arena, and radius of the object.
const int DIM = 256;
const int R   = 16;

// position of the object.
int x = 100, y = 50;
// directions
int dx = 2, dy = 1;

static IXQWidget* mainWidget;
IXQWidget_vtable mainWidgetTable;

// we use a pixmap for double-buffering. Actually, Qt will do it
// for us, but I test more things this way!
static IXQPixmap* backBuffer;

static IXQRect* ballRect()
{
    return I9(qrect_o5QRectiiii)(x - R, y - R, R*2, R*2);
}

static void handlePaintEvent(IXQWidget* __thisPtr, IXQPaintEvent* pe)
{
    // draw scene on backBuffer
    backBuffer->vtable()->fill(backBuffer, I9(qcolor_o6QColoriii)(255, 255, 192));
    IXQPainter* p = I9(qpainter_o8QPaintero12QPaintDevice)(backBuffer);
    p->vtable()->setHighQuality(p, true);

    IXQPen* pen = I9(qpen_o4QPeno6QColor)(I9(qcolor_o6QColoriii)(0, 0, 255));
    pen->vtable()->setWidth(pen, 5);
    p->vtable()->setPen(p, pen);
    p->vtable()->setBrush(p, I9(qbrush_o6QBrusho6QColor)(I9(qcolor_o6QColoriii)(255, 0, 0)));
    p->vtable()->drawEllipse(p, ballRect());
    p->vtable()->end(p);

    // paint the backbuffer
    IXQRect* dirty = pe->vtable()->rect(pe);
    IXQPainter* pw = I9(qpainter_o8QPaintero12QPaintDevice)(__thisPtr);
    pw->vtable()->drawPixmapPortion(pw, dirty->vtable()->topLeft(dirty),
                                    backBuffer, dirty);
    pw->vtable()->end(pw);
}

// Timer event listener
IXTimerListener_vtable listenerTable;

static void handleTimeout(IXTimerListener* __thisPtr, IXQTimer* timer)
{
    IXQRect* oldRect = ballRect();

    x += dx;
    y += dy;

    if (x + R >= DIM || (x - R)<= 0)
        dx = -dx;

    if (y + R >= DIM || (y - R) <= 0)
        dy = -dy;

    IXQRect* newRect = ballRect();
    IXQRect* both    = newRect->vtable()->united(newRect, oldRect);

    mainWidget->vtable()->repaint(mainWidget,
                                  both->vtable()->adjusted(both, -5, -5, 5, 5));
}

I9_EXPORT
void I9(main_paai)(int** args) {
    IXQAppCtorReturn ret;
    I9(qapplication_t2o12QApplicationaaiaai)(&ret, args);

    // Create a QWidget "subclass", with custom paintEvent
    // vtable here and not in init function.
    mainWidget = (IXQWidget*)I9(_alloc_i)(I9(_size_QWidget));
    mainWidgetTable = I9(_vt_QWidget);

    // override the events
    mainWidgetTable.paintEvent = handlePaintEvent;
    mainWidget->vptr = &mainWidgetTable;

    // create the back buffer pixmap
    backBuffer = I9(qpixmap_o7QPixmapii)(DIM, DIM);

    // create animation timer.
    IXQTimer* timer = I9(qtimer_o6QTimer)();

    // make our listener.
    IXTimerListener* l = (IXTimerListener*)I9(_alloc_i)(I9(_size_TimerListener));
    listenerTable = I9(_vt_TimerListener);
    listenerTable.timeout = handleTimeout;
    l->vptr = &listenerTable;
    // and add it.
    timer->vtable()->addTimerListener(timer, l);

    // start the timer..
    timer->vtable()->setSingleShot(timer, false);
    timer->vtable()->setInterval(timer, 40);
    timer->vtable()->start(timer);

    mainWidget->setFixedSize(mainWidget, I9(qsize_o5QSizeii)(DIM, DIM));
    mainWidget->vtable()->show(mainWidget);
    ret.app->vtable()->exec(ret.app);
}

