// A fancier bouncing ball demo, with menus and such

#include <bindqt.h>
#include <libi9.h>

// Dimension of the arena, and radius of the object.
const int DIM = 256;
const int R   = 16;

// position of the object.
int x = 100, y = 50;
// directions
int dx = 2, dy = 1;

static IXQWidget* mainWidget;
IXQWidget_vtable mainWidgetTable;

// we use a pixmap for double-buffering. Actually, Qt will do it
// for us, but I test more things this way!
static IXQPixmap* backBuffer;

static IXQRect* ballRect()
{
    return I9(qrect_o5QRectiiii)(x - R, y - R, R*2, R*2);
}

static void handlePaintEvent(IXQWidget* __thisPtr, IXQPaintEvent* pe)
{
    // draw scene on backBuffer
    backBuffer->vtable()->fill(backBuffer, I9(qcolor_o6QColoriii)(255, 255, 192));
    IXQPainter* p = I9(qpainter_o8QPaintero12QPaintDevice)(backBuffer);
    p->vtable()->setHighQuality(p, true);

    IXQPen* pen = I9(qpen_o4QPeno6QColor)(I9(qcolor_o6QColoriii)(0, 0, 255));
    pen->vtable()->setWidth(pen, 5);
    p->vtable()->setPen(p, pen);
    p->vtable()->setBrush(p, I9(qbrush_o6QBrusho6QColor)(I9(qcolor_o6QColoriii)(255, 0, 0)));
    p->vtable()->drawEllipse(p, ballRect());
    p->vtable()->end(p);

    // paint the backbuffer
    IXQRect* dirty = pe->vtable()->rect(pe);
    IXQPainter* pw = I9(qpainter_o8QPaintero12QPaintDevice)(__thisPtr);
    pw->vtable()->drawPixmapPortion(pw, dirty->vtable()->topLeft(dirty),
                                    backBuffer, dirty);
    pw->vtable()->end(pw);
}

// Timer event listener
IXTimerListener_vtable listenerTable;

IXQTimer* timer;

static void handleTimeout(IXTimerListener* __thisPtr, IXQTimer* timer)
{
    IXQRect* oldRect = ballRect();

    x += dx;
    y += dy;

    if (x + R >= DIM || (x - R)<= 0)
        dx = -dx;

    if (y + R >= DIM || (y - R) <= 0)
        dy = -dy;

    IXQRect* newRect = ballRect();
    IXQRect* both    = newRect->vtable()->united(newRect, oldRect);

    mainWidget->vtable()->repaint(mainWidget,
                                  both->vtable()->adjusted(both, -5, -5, 5, 5));
}

IXQAction *play, *stop;

// Our action listener
static void handleTriggered(IXActionListener* __this, IXQAction* a)
{
    if (a == play) {
        play->vtable()->setEnabled(play, false);
        stop->vtable()->setEnabled(stop, true);
        timer->vtable()->start(timer);
    } else {
        play->vtable()->setEnabled(play, true);
        stop->vtable()->setEnabled(stop, false);
        timer->vtable()->stop(timer);
    }
}

IXActionListener_vtable actionListTable;

I9_EXPORT
void I9(main_paai)(int** args) {
    IXQAppCtorReturn ret;
    I9(qapplication_t2o12QApplicationaaiaai)(&ret, args);

    // Create the main window
    IXQMainWindow* mw = I9(qmainwindow_o11QMainWindow)();

    // Create toolbar..
    IXQToolBar* tb = I9(qtoolbar_o8QToolBar)();
    tb->vtable()->setToolButtonStyle(tb, I9(ToolButtonTextBesideIcon_o15ToolButtonStyle)());

    mw->vtable()->addToolBar(mw, tb);

    // Create menu, add it.
    int pbStr[] = {8 , 'P', 'l', 'a', 'y', 'b', 'a', 'c', 'k'};
    IXQMenu* menu = I9(qmenu_o5QMenuo7QString)(I9(qs_o7QStringai)(pbStr+1));
    IXQMenuBar* mbar = mw->vtable()->menuBar(mw);
    mbar->vtable()->addMenu(mbar, menu);

    // Actions for animation..
    int playStr[] = { 4, 'P', 'l', 'a', 'y' };
    play = I9(qaction_o7QActiono7QString)(I9(qs_o7QStringai)(playStr+1));
    play->vtable()->setIcon(play, I9(qiconStandard_o5QIcono12StandardIcon)(I9(MediaPlay_o12StandardIcon)()));
    play->vtable()->setEnabled(play, false);

    int stopStr[] = { 4, 'S', 't', 'o', 'p' };
    stop = I9(qaction_o7QActiono7QString)(I9(qs_o7QStringai)(stopStr+1));
    stop->vtable()->setIcon(stop, I9(qiconStandard_o5QIcono12StandardIcon)(I9(MediaStop_o12StandardIcon)()));

    // add action listener.
    IXActionListener* al = (IXActionListener*)I9(_alloc_i)(I9(_size_ActionListener));
    actionListTable = I9(_vt_ActionListener);
    actionListTable.triggered = handleTriggered;
    al->vptr = &actionListTable;

    play->vtable()->addActionListener(play, al);
    stop->vtable()->addActionListener(stop, al);

    // Add them to toolbar, menu
    tb->vtable()->addAction(tb, play);
    tb->vtable()->addAction(tb, stop);

    menu->vtable()->addAction(menu, play);
    menu->vtable()->addAction(menu, stop);

    // Create a QWidget "subclass", with custom paintEvent
    // vtable here and not in init function.
    mainWidget = (IXQWidget*)I9(_alloc_i)(I9(_size_QWidget));
    mainWidgetTable = I9(_vt_QWidget);

    // override the events
    mainWidgetTable.paintEvent = handlePaintEvent;
    mainWidget->vptr = &mainWidgetTable;

    mainWidget->vtable()->setFixedSize(mainWidget, I9(qsize_o5QSizeii)(DIM, DIM));

    // create the back buffer pixmap
    backBuffer = I9(qpixmap_o7QPixmapii)(DIM, DIM);

    // create animation timer.
    timer = I9(qtimer_o6QTimer)();

    // make our timer listener.
    IXTimerListener* l = (IXTimerListener*)I9(_alloc_i)(I9(_size_TimerListener));
    listenerTable = I9(_vt_TimerListener);
    listenerTable.timeout = handleTimeout;
    l->vptr = &listenerTable;
    // and add it.
    timer->vtable()->addTimerListener(timer, l);

    // start the timer..
    timer->vtable()->setSingleShot(timer, false);
    timer->vtable()->setInterval(timer, 40);
    timer->vtable()->start(timer);

    // put it into the main window
    mw->vtable()->setCentralWidget(mw, mainWidget);
    mw->vtable()->show(mw);
    ret.app->vtable()->exec(ret.app);
}

