#ifndef IXQ_WRAPPER_FACTORY_H
#define IXQ_WRAPPER_FACTORY_H

#include <QObject>
#include <ixobj.h>
#include <ixqobjectholder.h>

struct IXQAction;
struct IXQWidget;
struct IXQPushButton;
struct IXQApplication;
struct IXQCheckBox;
struct IXQRadioButton;
struct IXQButtonGroup;
struct IXQMenu;
struct IXQToolBar;
struct IXQMenuBar;
struct IXQLabel;
struct IXQGroupBox;
struct IXQMainWindow;
struct IXQDialog;
struct IXQLineEdit;
struct IXQTextEdit;
struct IXQSlider;
struct IXQScrollBar;

// This method creates the wrapper of an appropriate type;
// e.g. if given a pure QWidget it will return a IXQWidget,
// while if it's given a QPushButton, it will return a IXQPushButton, etc.
IXobj* ixqCreateQObjectWrapper(QObject* ptr);

IXQAction*      toIX(QAction* act);
IXQPushButton*  toIX(QPushButton* b);
IXQCheckBox*    toIX(QCheckBox* b);
IXQRadioButton* toIX(QRadioButton* b);
IXQWidget*      toIX(QWidget* w);
IXQApplication* toIX(QApplication* a);
IXQButtonGroup* toIX(QButtonGroup* a);
IXQMenu*        toIX(QMenu* m);
IXQToolBar*     toIX(QToolBar* t);
IXQMenuBar*     toIX(QMenuBar* m);
IXQLabel*       toIX(QLabel* m);
IXQMainWindow*  toIX(QMainWindow* m);
IXQGroupBox*    toIX(QGroupBox* m);
IXQDialog*      toIX(QDialog* m);
IXQLineEdit*    toIX(QLineEdit* m);
IXQTextEdit*    toIX(QTextEdit* m);
IXQScrollBar*   toIX(QScrollBar* m);
IXQSlider*      toIX(QSlider* m);
#endif
