#include <cassert>

#include <QAction>
#include <QWidget>
#include <QPushButton>
#include <QCheckBox>
#include <QRadioButton>
#include <QMenu>
#include <QToolBar>
#include <QMenuBar>
#include <QLabel>
#include <QGroupBox>
#include <QMainWindow>
#include <QDialog>
#include <QLineEdit>
#include <QTextEdit>
#include <QSlider>
#include <QScrollBar>

#include "ixqwrapperfactory.h"
#include "bindqt.h"

template<typename WrapperType, typename QtType>
WrapperType* makeWrapper(QtType* q)
{
    WrapperType* ix = gcNew<WrapperType>();
    ix->setObject(q);
    return ix;
}

template<typename WrapperType>
WrapperType* tryMakeWrapper(QObject* ptr)
{
    typename WrapperType::wrappedType* cptr;
    if (cptr = qobject_cast<typename WrapperType::wrappedType*>(ptr))
        return makeWrapper<WrapperType, typename WrapperType::wrappedType>(cptr);

    return 0;
}

IXobj* ixqCreateQObjectWrapper(QObject* ptr)
{
    IXobj* r = 0;
    if (ptr->isWidgetType()) {
        r = r ? r : tryMakeWrapper<IXQPushButton>(ptr);
        r = r ? r : tryMakeWrapper<IXQCheckBox>(ptr);
        r = r ? r : tryMakeWrapper<IXQRadioButton>(ptr);
        r = r ? r : tryMakeWrapper<IXQMenu>(ptr);
        r = r ? r : tryMakeWrapper<IXQToolBar>(ptr);
        r = r ? r : tryMakeWrapper<IXQMenuBar>(ptr);
        r = r ? r : tryMakeWrapper<IXQLabel>(ptr);
        r = r ? r : tryMakeWrapper<IXQGroupBox>(ptr);
        r = r ? r : tryMakeWrapper<IXQMainWindow>(ptr);
        r = r ? r : tryMakeWrapper<IXQDialog>(ptr);
        r = r ? r : tryMakeWrapper<IXQLineEdit>(ptr);
        r = r ? r : tryMakeWrapper<IXQTextEdit>(ptr);
        r = r ? r : tryMakeWrapper<IXQSlider>(ptr);
        r = r ? r : tryMakeWrapper<IXQScrollBar>(ptr);
        r = r ? r : tryMakeWrapper<IXQAbstractSlider>(ptr); // must be below QSlider, QScrollBar
        r = r ? r : makeWrapper<IXQWidget, QWidget>(static_cast<QWidget*>(ptr));
        return r;
    }

    r = r ? r : tryMakeWrapper<IXQAction>(ptr);
    r = r ? r : tryMakeWrapper<IXQButtonGroup>(ptr);
    r = r ? r : tryMakeWrapper<IXQApplication>(ptr);

    assert(r);
    return r;
}

IXobj* qobjectToIX(QObject* ptr) {
    if (!ptr)
        return 0;

    IXobj* o;
    if ((o = ixqGetWrapper(ptr)))
        return o;

    o = ixqCreateQObjectWrapper(ptr);
    assert(ixqGetWrapper(ptr) == o);
    return o;
}

template<typename IXType, typename QType = typename IXType::wrappedType>
struct ToIX_Adjustor
{
    IXType* operator() (QType* orig) {
        return static_cast<IXType*>(qobjectToIX(static_cast<QObject*>(orig)));
    }
};

IXQAction* toIX(QAction* act) {
    return ToIX_Adjustor<IXQAction>()(act);
}

IXQWidget* toIX(QWidget* w) {
    return ToIX_Adjustor<IXQWidget>()(w);
}

IXQPushButton* toIX(QPushButton* b) {
    return ToIX_Adjustor<IXQPushButton>()(b);
}

IXQCheckBox* toIX(QCheckBox* b) {
    return ToIX_Adjustor<IXQCheckBox>()(b);
}

IXQRadioButton* toIX(QRadioButton* b) {
    return ToIX_Adjustor<IXQRadioButton>()(b);
}

IXQButtonGroup* toIX(QButtonGroup* b) {
    return ToIX_Adjustor<IXQButtonGroup>()(b);
}

IXQMenu* toIX(QMenu* b) {
    return ToIX_Adjustor<IXQMenu>()(b);
}

IXQToolBar* toIX(QToolBar* b) {
    return ToIX_Adjustor<IXQToolBar>()(b);
}

IXQApplication* toIX(QApplication* a) {
    return ToIX_Adjustor<IXQApplication>()(a);
}

IXQMenuBar* toIX(QMenuBar* b) {
    return ToIX_Adjustor<IXQMenuBar>()(b);
}

IXQLabel* toIX(QLabel* b) {
    return ToIX_Adjustor<IXQLabel>()(b);
}

IXQGroupBox* toIX(QGroupBox* b) {
    return ToIX_Adjustor<IXQGroupBox>()(b);
}

IXQMainWindow* toIX(QMainWindow* b) {
    return ToIX_Adjustor<IXQMainWindow>()(b);
}

IXQDialog* toIX(QDialog* b) {
    return ToIX_Adjustor<IXQDialog>()(b);
}

IXQLineEdit* toIX(QLineEdit* b) {
    return ToIX_Adjustor<IXQLineEdit>()(b);
}

IXQTextEdit* toIX(QTextEdit* b) {
    return ToIX_Adjustor<IXQTextEdit>()(b);
}

IXQScrollBar* toIX(QScrollBar* b) {
    return ToIX_Adjustor<IXQScrollBar>()(b);
}

IXQSlider* toIX(QSlider* b) {
    return ToIX_Adjustor<IXQSlider>()(b);
}

