#ifndef IXQ_SLOT_H
#define IXQ_SLOT_H

#include <ixobj.h>

#include <QObject>
#include <QCheckBox>
#include <QPushButton>
#include <QRadioButton>
#include <QAbstractSlider>

// An ultra-simple list that's stored in the GC heap,
// so it can be traced accross (as the normal heap can't be)
template<typename T>
struct ixqEventListenerList
{
    struct Cell
    {
        T* listener;
        Cell* next;
    };

    void append(T* listener) {
        Cell* newCell = gcCalloc<Cell>();
        newCell->listener = listener;

        if (head) {
            tail->next = newCell;
            tail = newCell;
        } else {
            head = tail = newCell;
        }
    }

    Cell* head;
    Cell* tail;

    ixqEventListenerList(): head(0), tail(0)
    {}
};

struct IXQPushButton;
class IXQPushButtonSigs: public QObject
{
    Q_OBJECT
public:
    IXQPushButtonSigs(IXQPushButton* ixObj, QPushButton* qObj);
private slots:
    void slotClicked(bool);
private:
    IXQPushButton* ixObj;
    QPushButton*   qObj;
};

struct IXQTimer;
class IXQTimerSigs: public QObject
{
    Q_OBJECT
public:
    IXQTimerSigs(IXQTimer* ixObj, QTimer* qObj);
private slots:
    void slotTimeout();
private:
    IXQTimer* ixObj;
    QTimer*   qObj;
};


struct IXQApplication;
class IXQApplicationSigs: public QObject
{
    Q_OBJECT
public:
    IXQApplicationSigs(IXQApplication* ixObj, QApplication* qObj);
private slots:
    void slotAboutToQuit();
private:
    IXQApplication* ixObj;
    QApplication*   qObj;
};

struct IXQAction;
class IXQActionSigs: public QObject
{
    Q_OBJECT
public:
    IXQActionSigs(IXQAction* ixObj, QAction* qObj);
private slots:
    void slotTriggered();
private:
    IXQAction* ixObj;
    QAction*   qObj;
};

struct IXQCheckBox;
class IXQCheckBoxSigs: public QObject
{
    Q_OBJECT
public:
    IXQCheckBoxSigs(IXQCheckBox* ixObj, QCheckBox* qObj);
private slots:
    void slotToggled(bool);
private:
    IXQCheckBox* ixObj;
    QCheckBox*   qObj;
};

struct IXQRadioButton;
class IXQRadioButtonSigs: public QObject
{
    Q_OBJECT
public:
    IXQRadioButtonSigs(IXQRadioButton* ixObj, QRadioButton* qObj);
private slots:
    void slotToggled(bool);
private:
    IXQRadioButton* ixObj;
    QRadioButton*   qObj;
};

struct IXQAbstractSlider;
class IXQAbstractSliderSigs: public QObject
{
    Q_OBJECT
public:
    IXQAbstractSliderSigs(IXQAbstractSlider* ixObj, QAbstractSlider* qObj);
private slots:
    void slotSliderMoved(int);
private:
    IXQAbstractSlider* ixObj;
    QAbstractSlider*   qObj;
};


#endif
