#include <ixqslot.h>
#include <bindqt.h>

IXQPushButtonSigs::IXQPushButtonSigs(IXQPushButton* ixObj, QPushButton* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(clicked(bool)),
            this, SLOT(slotClicked(bool)));
}

void IXQPushButtonSigs::slotClicked(bool)
{
    // Dispatch to the peer, and all its listeners.
    ixObj->vtable()->clicked(ixObj);

    ixqEventListenerList<IXClickListener>::Cell* cur;
    for (cur = ixObj->clickListeners.head; cur; cur = cur->next)
        cur->listener->vtable()->clicked(cur->listener, ixObj);
}

///////////////////////////////////////////////////////////////////////////////
IXQTimerSigs::IXQTimerSigs(IXQTimer* ixObj, QTimer* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(timeout()),
            this, SLOT(slotTimeout()));
}

void IXQTimerSigs::slotTimeout()
{
    // Dispatch to the peer, and all its listeners.
    ixObj->vtable()->timeout(ixObj);

    ixqEventListenerList<IXTimerListener>::Cell* cur;
    for (cur = ixObj->timerListeners.head; cur; cur = cur->next)
        cur->listener->vtable()->timeout(cur->listener, ixObj);
}


///////////////////////////////////////////////////////////////////////////////
IXQApplicationSigs::IXQApplicationSigs(IXQApplication* ixObj, QApplication* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(aboutToQuit()),
            this, SLOT(slotAboutToQuit()));
}

void IXQApplicationSigs::slotAboutToQuit()
{
    // Dispatch to the peer, and all its listeners.
    ixqEventListenerList<IXAboutToQuitListener>::Cell* cur;
    for (cur = ixObj->quitListeners.head; cur; cur = cur->next)
        cur->listener->vtable()->aboutToQuit(cur->listener);
}

///////////////////////////////////////////////////////////////////////////////
IXQActionSigs::IXQActionSigs(IXQAction* ixObj, QAction* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(triggered(bool)),
            this, SLOT(slotTriggered()));
}

void IXQActionSigs::slotTriggered()
{
    ixObj->vtable()->triggered(ixObj);
    ixqEventListenerList<IXActionListener>::Cell* cur;
    for (cur = ixObj->actionListeners.head; cur; cur = cur->next)
        cur->listener->vtable()->triggered(cur->listener, ixObj);
}

///////////////////////////////////////////////////////////////////////////////
IXQCheckBoxSigs::IXQCheckBoxSigs(IXQCheckBox* ixObj, QCheckBox* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(toggled(bool)),
            this, SLOT(slotToggled(bool)));
}

void IXQCheckBoxSigs::slotToggled(bool v)
{
    ixObj->vtable()->toggled(ixObj, v);
    ixqEventListenerList<IXToggleListener>::Cell* cur;
    for (cur = ixObj->listeners.head; cur; cur = cur->next)
        cur->listener->vtable()->toggled(cur->listener, ixObj, v);
}

///////////////////////////////////////////////////////////////////////////////
IXQRadioButtonSigs::IXQRadioButtonSigs(IXQRadioButton* ixObj, QRadioButton* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(toggled(bool)),
            this, SLOT(slotToggled(bool)));
}

void IXQRadioButtonSigs::slotToggled(bool v)
{
    ixObj->vtable()->toggled(ixObj, v);
    ixqEventListenerList<IXToggleListener>::Cell* cur;
    for (cur = ixObj->listeners.head; cur; cur = cur->next)
        cur->listener->vtable()->toggled(cur->listener, ixObj, v);
}

///////////////////////////////////////////////////////////////////////////////
IXQAbstractSliderSigs::IXQAbstractSliderSigs(IXQAbstractSlider* ixObj, QAbstractSlider* qObj):
    ixObj(ixObj), qObj(qObj)
{
    connect(qObj, SIGNAL(sliderMoved(int)),
            this, SLOT(slotSliderMoved(int)));
}

void IXQAbstractSliderSigs::slotSliderMoved(int v)
{
    ixObj->vtable()->sliderMoved(ixObj, v);
    ixqEventListenerList<IXSliderListener>::Cell* cur;
    for (cur = ixObj->sliderListeners.head; cur; cur = cur->next)
        cur->listener->vtable()->sliderMoved(cur->listener, ixObj, v);
}

