#include <ixqproxywidgets.h>
#include <ixqobjectholder.h> // for getWrapper
#include <bindqt.h>

template<typename IXType, typename QType = typename IXType::wrappedType>
struct ToIX_Event
{
    IXType* operator() (QType* orig) {
        IXType* o = gcNew<IXType>();
        o->e = orig;
        return o;
    }
};

template<typename T>
void Proxy<T>::paintEvent(QPaintEvent* pe)
{
    // Find our wrapper. It must exist, since we were created by one.
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->paintEvent(wrapper, ToIX_Event<IXQPaintEvent>()(pe));
}

template<typename T>
void Proxy<T>::mousePressEvent(QMouseEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->mousePressEvent(wrapper, ToIX_Event<IXQMouseEvent>()(e));
}

template<typename T>
void Proxy<T>::mouseReleaseEvent(QMouseEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->mouseReleaseEvent(wrapper, ToIX_Event<IXQMouseEvent>()(e));
}

template<typename T>
void Proxy<T>::mouseDoubleClickEvent(QMouseEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->mouseDoubleClickEvent(wrapper, ToIX_Event<IXQMouseEvent>()(e));
}

template<typename T>
void Proxy<T>::mouseMoveEvent(QMouseEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->mouseMoveEvent(wrapper, ToIX_Event<IXQMouseEvent>()(e));
}

template<typename T>
void Proxy<T>::wheelEvent(QWheelEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->wheelEvent(wrapper, ToIX_Event<IXQWheelEvent>()(e));
}

template<typename T>
void Proxy<T>::keyPressEvent(QKeyEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->keyPressEvent(wrapper, ToIX_Event<IXQKeyEvent>()(e));
}

template<typename T>
void Proxy<T>::keyReleaseEvent(QKeyEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->keyReleaseEvent(wrapper, ToIX_Event<IXQKeyEvent>()(e));
}

template<typename T>
void Proxy<T>::enterEvent(QEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->enterEvent(wrapper, ToIX_Event<IXQEvent>()(e));
}

template<typename T>
void Proxy<T>::leaveEvent(QEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->leaveEvent(wrapper, ToIX_Event<IXQEvent>()(e));
}

template<typename T>
void Proxy<T>::resizeEvent(QResizeEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->resizeEvent(wrapper, ToIX_Event<IXQResizeEvent>()(e));
}

template<typename T>
void Proxy<T>::closeEvent(QCloseEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->closeEvent(wrapper, ToIX_Event<IXQEvent>()(e));
}

template<typename T>
void Proxy<T>::contextMenuEvent(QContextMenuEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->contextMenuEvent(wrapper, ToIX_Event<IXQContextMenuEvent>()(e));
}

template<typename T>
void Proxy<T>::showEvent(QShowEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->showEvent(wrapper, ToIX_Event<IXQEvent>()(e));
}

template<typename T>
void Proxy<T>::hideEvent(QHideEvent* e)
{
    IXQWidget* wrapper = static_cast<IXQWidget*>(ixqGetWrapper(this));
    wrapper->vtable()->hideEvent(wrapper, ToIX_Event<IXQEvent>()(e));
}

template<typename T>
void Proxy<T>::defaultEvent(QEvent* e)
{
    // Matches the code in QWidget::event, for the types we support.
    switch (e->type()) {
    case QEvent::MouseMove:
        T::mouseMoveEvent(static_cast<QMouseEvent*>(e));
        break;
    case QEvent::MouseButtonPress:
        T::mousePressEvent(static_cast<QMouseEvent*>(e));
        break;
    case QEvent::MouseButtonRelease:
        T::mouseReleaseEvent(static_cast<QMouseEvent*>(e));
        break;
    case QEvent::MouseButtonDblClick:
        T::mouseDoubleClickEvent(static_cast<QMouseEvent*>(e));
        break;
    case QEvent::ContextMenu:
        T::contextMenuEvent(static_cast<QContextMenuEvent*>(e));
        break;
    case QEvent::Wheel:
        T::wheelEvent(static_cast<QWheelEvent*>(e));
        break;
    case QEvent::KeyPress:
        T::keyPressEvent(static_cast<QKeyEvent*>(e));
        break;
    case QEvent::KeyRelease:
        T::keyReleaseEvent(static_cast<QKeyEvent*>(e));
        break;
    case QEvent::Enter:
        T::enterEvent(e);
        break;
    case QEvent::Leave:
        T::leaveEvent(e);
        break;
    case QEvent::Resize:
        T::resizeEvent(static_cast<QResizeEvent*>(e));
        break;
    case QEvent::Close:
        T::closeEvent(static_cast<QCloseEvent*>(e));
        break;
    case QEvent::Show:
        T::showEvent(static_cast<QShowEvent*>(e));
        break;
    case QEvent::Hide:
        T::hideEvent(static_cast<QHideEvent*>(e));
        break;
    case QEvent::Paint:
        T::paintEvent(static_cast<QPaintEvent*>(e));
        break;
    default:
        assert(0);
    }
}

// Force instanciation.
template class Proxy<QWidget>;
template class Proxy<QPushButton>;
template class Proxy<QCheckBox>;
template class Proxy<QRadioButton>;
template class Proxy<QMenu>;
template class Proxy<QToolBar>;
template class Proxy<QMenuBar>;
template class Proxy<QLabel>;
template class Proxy<QGroupBox>;
template class Proxy<QMainWindow>;
template class Proxy<QLineEdit>;
template class Proxy<QDialog>;
template class Proxy<QTextEdit>;
template class Proxy<QAbstractSlider>;
template class Proxy<QSlider>;
template class Proxy<QScrollBar>;
