#include "ixqobjectholder.h"

#include <QHash>

static QHash<QObject*, IXobj*>* s_wrappers;

static QHash<QObject*, IXobj*>& wrappers() {
    if (!s_wrappers)
        s_wrappers = new QHash<QObject*, IXobj*>;
    return *s_wrappers;
}

IXobj* ixqGetWrapper(QObject* object)
{
    return wrappers().value(object);
}

void ixqPutWrapper(QObject* object, IXobj* wrapper)
{
    assert (!wrappers().contains(object));
    wrappers().insert(object, wrapper);
}

void ixqForgetWrapper(QObject* object)
{
    assert (wrappers().contains(object));
    wrappers().remove(object);
}

// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on;
