#ifndef IX_OBJ_H
#define IX_OBJ_H

#include <new>

#include "libi9.h"

struct IXvtable {
};

struct IXobj {
    IXobj(): initialized(true)
    {}

    IXvtable* vptr;

    // This field is set to false when we are merely allocated
    // via GC, such as when an IX subclass allocates our memory;
    // and true when we've actually called a constructor.
    bool initialized;
};

template<typename T> T* gcNew() {
    T* t = reinterpret_cast<T*>(I9(_alloc_i)(sizeof(T)));
    new (t) T;
    i9_registerFinalizer(t, T::invokeDtor);
    return t;
}

// Like gcNew, but doesn't deal with constructors or destructors
template<typename T> T* gcCalloc() {
    return reinterpret_cast<T*>(I9(_alloc_i)(sizeof(T)));
}

inline int toIX(int v) {
    return v;
}

inline bool toIX(bool v) {
    return v;
}

inline int fromIX(int v) {
    return v;
}

inline bool fromIX(bool v) {
    return v;
}

inline void* fromIX(void* v) {
    return v;
}

enum ClassOp {
    CallCtor, // also responsible for calling createImpl
    CallDtor
};

struct DummyPeer
{};

#endif

// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on; hl c++;
