package edu.cornell.cs.cs4120.iota.parser;

import edu.cornell.cs.cs4120.iota.IotaAbstractSyntaxNode;
import edu.cornell.cs.cs4120.iota.IotaCompilationException;

/**
 * A parser for the Iota language.
 */
public interface IotaParser {
  /**
   * Returns an abstract syntax representation of an Iota program.
   * 
   * @return an AST representing a program
   * @throws IotaCompilationException
   *           if there is a syntax error in the program
   */
  IotaAbstractSyntaxNode parse() throws IotaCompilationException;
}
