#include "libi9.h"

// Internal helper for making arrays
static void* i9_mkArray(int bytes, int cells) {
    int* memory = I9(_alloc_i)(bytes + 4);
    memory[0] = cells;
    return memory + 1;
}

int** I9(mkMatrix_aaii)(int size) {
    int** topLevel = (int**)i9_mkArray(size*sizeof(int*), size);
    int c;
    for (c = 0; c < size; ++c) {
        topLevel[c] = (int*)i9_mkArray(size*sizeof(int), size);
    }
    return topLevel;
}

int** I9(mkRectMatrix_aaiii)(int rows, int cols) {
    int** topLevel = (int**)i9_mkArray(rows*sizeof(int*), rows);
    int c;
    for (c = 0; c < rows; ++c) {
        topLevel[c] = (int*)i9_mkArray(cols*sizeof(int), cols);
    }
    return topLevel;
}
