var numTests;
var numTeams;

function initGlobals(t) {
    numTests = (t.tBodies[0].rows[0].cells.length - 1)/4;
    numTeams = t.tBodies[0].rows.length;
}

function setCellText(c, t) {
    while (c.firstChild)
        c.removeChild(c.firstChild);
    var p = document.createElement("pre");
    p.innerText   = t;
    p.textContent = t;
    c.appendChild(p);
    c.setAttribute("nowrap", "true");
}

function getCellText(c) {
    var txt =  c.innerText ? c.innerText: c.textContent;
    if (typeof txt != "string")
        return "";
    return txt;
}

// Extracts number or undefined if failed, post-conversion
function extractTestResult(v) {
    var t = getCellText(v);
    if (t.indexOf("ms") == "-1")
        return undefined;
    else
        return Number(t.substr(0, t.indexOf("ms")));
}

// Figures out the # of subcolumns.
function subColumns(t) {
    return Number(t.tHead.rows[0].cells[1].colSpan);
}

// # of subcolumns in the final means/etc. rows
function summarySubColumns(t) {
    var cells = t.tHead.rows[0].cells;
    return Number(cells[cells.length - 1].colSpan);
}


// Time constants, starting from 0.
var COMPILE_OPT = 0;
var RUN_OPT     = 1;
var COMPILE_UN  = 2;
var RUN_UN      = 3;
var NumCats     = 4;

// Modes for summary
var SUM_GCC   = 0;
var SUM_STAFF = 1;
var SUM_ALL   = 2;

function baseColumn(t, testNum) {
    var scNormal = subColumns(t);
    if (testNum < numTests) {
        // Just normal groups.
        return 1 + scNormal * testNum;
    } else {
        // Also summary groups, with diff # of columns
        var base = 1 + scNormal * numTests;
        return base + (testNum - numTests) * summarySubColumns(t);
    }
}

function getTime(t, r, testNum, cat) {
    return extractTestResult(t.tBodies[0].rows[r].cells[baseColumn(t, testNum) + cat]);
}

function getGroupName(t, r) {
    return getCellText(t.tBodies[0].rows[r].cells[0]);
}

function setSpeedup(t, r, testNum, v) {
    setCellText(t.tBodies[0].rows[r].cells[baseColumn(t, testNum) + 4], v);
}

function getSpeedup(t, r, testNum, v) {
    return Number(getCellText(t.tBodies[0].rows[r].cells[4 + baseColumn(t, testNum)]));
}

function testName(t, idx) {
    return getCellText(t.tHead.rows[0].cells[idx + 1]);
}

// Do statistical analysis on comma-separate multi-run stuff,
// collapsing it into one.
function convertStats(t) {
    var b = t.tBodies[0];

    for (var ri = 0; ri < b.rows.length; ++ri) {
        var r = b.rows[ri];

        // First cell is benchmark name, so can ignore it
        for (var ci = 1; ci < r.cells.length; ++ci) {
            var c = r.cells[ci];
            var txt = getCellText(c);

            if (txt.indexOf("FAIL") != -1) {
                setCellText(c, "FAIL");
                c.bgColor = "red";
            } else if (txt.indexOf("ALMOST") != -1) {
                setCellText(c, "ALMOST");
                c.bgColor = "yellow";
            } else if (txt.indexOf(",") != -1) {
                a = txt.split(",");
                // get rid of trailing comma-caused empty element.
                a.length = a.length - 1;
                for (var i = 0; i < a.length; ++i)
                    a[i] = Number(a[i]) * 1000;

                setCellText(c, formatResult(a));
                c.align = "right";
                c.bgColor = "#00FF00";
            } else if (txt.length > 0) {
                setCellText(c, formatResult([Number(txt)*1000]));
            }
        }
    }
}

function prettifyTable() {
    var t = document.getElementById("t");

    initGlobals(t);
    convertStats(t);
    computeSpeedupRatios(t);
    initBenchMeans(t);
    findGCCTests(t);
    addSummaryMeans(t, SUM_GCC);
    addSummaryMeans(t, SUM_STAFF);
    addSummaryMeans(t, SUM_ALL);
    addCursorTracket(t);
}

function computeSpeedupRatios(t) {
    // First of all, add in columns in head...
    var h = t.tHead.rows[1];
    for (var ti = 0; ti < numTests; ++ti) {
        var c = h.insertCell(ti*5 + 4);
        setCellText(c, "Speedup");
    }

    // Fix up colspans.
    var th = t.tHead.rows[0];
    for (var ci = 1; ci < th.cells.length; ++ ci) {
        th.cells[ci].colSpan = 5;
    }

    // Add columns elsewhere
    var b = t.tBodies[0];
    for (var ri = 0; ri < b.rows.length; ++ri) {
        var r = b.rows[ri];
        for (var ti = 0; ti < numTests; ++ti) {
            r.insertCell(ti*5 + 5);
        }
    }

    // Go ahead and actually compute them.
    for (var ri = 0; ri < b.rows.length; ++ri) {
        for (var ti = 0; ti < numTests; ++ti) {
            var opt   = getTime(t, ri, ti, RUN_OPT);
            var unopt = getTime(t, ri, ti, RUN_UN);
            if (!opt || !unopt)
                continue;
            setSpeedup(t, ri, ti, (unopt/opt).toFixed(2));
        }
    }
}

function geometricMean(items) {
    // ... I am sort of worried of precision here.
    var p = 1;
    for (var i = 0; i < items.length; ++i)
        p = p * items[i];
    return Math.pow(p, 1/items.length);
}

// Means for benchmarks that run. Indexed first by test,
// then by COMPILE_OPT/etc. enum
// Undefined if not to be used.
var means = [];

function initBenchMeans(t) {
    for (var ti = 0; ti < numTests; ++ti) {
        means[ti] = [];
        found = [];
        for (var cat = 0; cat < NumCats; ++cat) {
            found[cat] = [];
            for (var r = 0; r < numTeams; ++r) {
                if (getGroupName(t, r) == "gcc") // don't want it in defaults.
                    continue;

                var time = getTime(t, r, ti, cat);
                if (time)
                    found[cat].push(time);
            }

            if (found[cat].length) {
                means[ti][cat] = geometricMean(found[cat]);
            }
        } // for category
    } // for test
}

// finds all tests that have C version, but looking at the row for gcc
var gccTests = [];
function findGCCTests(t) {
    for (var ri = 0; ri < numTeams; ++ri) {
        if (getGroupName(t, ri) == "gcc") {
            for (var ti = 0; ti < numTests; ++ti) {
                if (getTime(t, ri, ti, COMPILE_OPT))
                    gccTests[ti] = true;
            }
        } // if gcc
    } // team #
}

function addSubHeading(t, txt) {
    var c = t.tHead.rows[1].insertCell(-1);
    setCellText(c, txt);
    var headerCells = t.tHead.rows[0].cells;
    ++headerCells[headerCells.length - 1].colSpan;
}

function addSummaryMeans(t, mode) {
    function shouldSkipTest(ti) {
        switch (mode) {
            case SUM_ALL:
                return false;
            case SUM_STAFF:
                return testName(t, ti).indexOf("student") != -1;
            case SUM_GCC:
                return !gccTests[ti];
        }
    }

    function appendMeasurement(t, ri, txt, colorOpt) {
        // Note: for gcc row, we want to avoid outputting anything
        // except in its measure.

        if (isGCC && (mode != SUM_GCC)) {
            colorOpt = undefined;
            txt = "";
        }
        var c = t.tBodies[0].rows[ri].insertCell(-1)
        setCellText(c, txt);

        try { // No CSS3 colors in IE
            if (colorOpt)
                c.style.background = colorOpt;
        } catch (e) {}
    }


    // Main heading for means
    var c = document.createElement("th");

    if (mode == SUM_STAFF)
        setCellText(c, "Mean (staff)");
    else if (mode == SUM_ALL)
        setCellText(c, "Mean (all)");
    else
        setCellText(c, "Mean (w/C)");
    t.tHead.rows[0].appendChild(c);

    // Now subheadings -- copy them over
    for (var s = 0; s < 5; ++s) {
        addSubHeading(t, getCellText(t.tHead.rows[1].cells[s]));
    }

    addSubHeading(t, "% Comp (+O)");
    addSubHeading(t, "% Work (+O)");
    addSubHeading(t, "% Comp (-O)");
    addSubHeading(t, "% Work (-O)");

    // For each group, add in mean for each subcategory, substituting
    // in defaults for each test if possible.
    for (var ri = 0; ri < numTeams; ++ri) {
        var isGCC = getGroupName(t, ri) == "gcc";

        for (var cat = 0; cat < NumCats; ++cat) {
            var samples = [];
            for (var ti = 0; ti < numTests; ++ti) {
                if (shouldSkipTest(ti))
                    continue;

                var time = getTime(t, ri, ti, cat);
                if (!time)
                    time = means[ti][cat];
                if (time)
                    samples.push(time);
            }

            appendMeasurement(t, ri,formatResult([geometricMean(samples)]));
        }

        // Mean speed up is w/o defaults.
        var samples = [];
        for (var ti = 0; ti < numTests; ++ti) {
            if (shouldSkipTest(ti))
                continue;

            var time = getSpeedup(t, ri, ti);
            if (time)
                samples.push(time);
        }

        appendMeasurement(t, ri, geometricMean(samples).toFixed(2));

        // % that do X.. again for each subcat.
        for (var cat = 0; cat < NumCats; ++cat) {
            var ok = 0, total = 0;
            for (var ti = 0; ti < numTests; ++ti) {
                if (shouldSkipTest(ti))
                    continue;
                ++total;

                var time = getTime(t, ri, ti, cat);
                if (time)
                    ++ok;
            }

            appendMeasurement(t, ri, ((ok/total)*100).toFixed(2) + "%",
                              "hsl(" + (120*(ok/total)).toFixed(0) + ",100%, 50%)");
        }
    }
}

function addCursorTracket(t) {
    function track(event) {
        var node = event.target;

        while (node && node.tagName != "TR")
            node = node.parentNode;

        if (node) {
            s.style.display = "inline";
            s.style.left = (window.scrollX + event.screenX - t.offsetLeft) + "px";
            s.innerHTML = getCellText(node.cells[0]);
        } else {
            s.style.display = "none";
        }
    }

    var wrap = document.createElement("p");
    t.parentNode.appendChild(wrap);

    var s = document.createElement("span");
    s.setAttribute("style", "position: relative; border: 1px solid grey; width: 100%;"
                            + "background: InfoBackground; color: InfoText;");
    wrap.appendChild(s);

    if (!t.addEventListener)
        return; // Does IE still not support DOM events?

    t.addEventListener("mousemove", track, false);
}

/*
 * Some of the statistics routines were taken from SunSpider
 * benchmark's driver, which was distributed under the
 * following terms:
 *
 * Copyright (C) 2007 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

function meanOf(items) {
    var sum = 0;
    for (var i = 0; i < items.length; i++) {
        sum += items[i];
    }
    return sum/items.length;
}

function standardDeviation(items)
{
    var mean = meanOf(items)
    var deltaSquaredSum = 0;
    for (var i = 0; i < items.length; i++) {
        var delta = items[i] - mean;
        deltaSquaredSum += delta * delta;
    }
    var variance = deltaSquaredSum / (items.length - 1);
    return Math.sqrt(variance);
}

function standardError(items)
{
    var stdDev = standardDeviation(items);
    var sqrtCount = Math.sqrt(items.length);
    return stdDev / sqrtCount;
}

var tDistribution = [NaN, NaN, 12.71, 4.30, 3.18, 2.78, 2.57, 2.45, 2.36, 2.31, 2.26, 2.23, 2.20, 2.18, 2.16, 2.14, 2.13, 2.12, 2.11, 2.10, 2.09, 2.09, 2.08, 2.07, 2.07, 2.06, 2.06, 2.06, 2.05, 2.05, 2.05, 2.04, 2.04, 2.04, 2.03, 2.03, 2.03, 2.03, 2.03, 2.02, 2.02, 2.02, 2.02, 2.02, 2.02, 2.02, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.99, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.98, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.97, 1.96];
var tMax = tDistribution.length;
var tLimit = 1.96;

function tDist(n)
{
    if (n > tMax)
        return tLimit;
    return tDistribution[n];
}


function formatResult(items)
{
    var mean = meanOf(items);
    var n    = items.length;
    var stdErr = standardError(items);
    var meanString = mean.toFixed(1).toString();

    if (n == 1)
        return meanString + "ms";

    return meanString + "ms +/- " + ((tDist(n) * stdErr / mean) * 100).toFixed(1) + "%";
}


