#include "arr.h"
#include <stdio.h>

// Just a version of arrays-of-arrays
#define arr2_at(a, idx) (int*)arr_at((int*)a, idx)

int** mkRectMatrix(int rows, int cols) {
    int c;
    int** topLevel = (int**)arr_alloc(rows);
    for (c = 0; c < rows; ++c)
        topLevel[c] = arr_alloc(cols);
        // no check here since the other mkmatrix is in C as well.
    return topLevel;
}


// Silently assumes compatible sizes
int** matMult(int** A, int** B) {
    int rowsA = arr_len(A);
    int colsA = arr_len(arr2_at(A, 0)); // aka rowsB
    int colsB = arr_len(arr2_at(B, 0));

    int** out = mkRectMatrix(rowsA, colsB);

    int outRow = 0;
    while (outRow < rowsA) {
        int outCol = 0;
        while (outCol < colsB) {
            int dotVal = 0;

            int dotPos = 0;
            while (dotPos < colsA) {
                dotVal = dotVal +
                    arr_at(arr2_at(A, outRow), dotPos)
                    * arr_at(arr2_at(B, dotPos), outCol);
                dotPos = dotPos + 1;
            }
            arr_at(arr2_at(out, outRow), outCol) = dotVal;

            outCol = outCol + 1;
        }

        outRow = outRow + 1;
    }

    return out;
}

int main() {
    int D1 = 600;
    int D2 = 500;
    int D3 = 400;
    // multiply a D1 x D2 matrix by a D2 x D3 one.
    int** A = mkRectMatrix(D1, D2);
    int** B = mkRectMatrix(D2, D3);

    // Init matrix 1
    int r = 0;
    while (r < D1) {
        int c = 0;
        while (c < D2) {
            arr_at(arr2_at(A, r), c) = r + c;
            c = c + 1;
        }

        r = r + 1;
    }

    // and #2
    r = 0;
    while (r < D2) {
        int c = 0;
        while (c < D3) {
            arr_at(arr2_at(B, r), c) = r - c;
            c = c + 1;
        }

        r = r + 1;
    }

    // multiply
    int** C = matMult(A, B);

    printf("%d\n", C[0][0]);
    printf("%d\n", C[15][3]);
    printf("%d\n", C[2][7]);

    return 0;
}

