package edu.cornell.cs.cs4120.iota.lexer;

import java.util.Iterator;
import java.util.NoSuchElementException;

import edu.cornell.cs.cs4120.iota.IotaCompilationException;

/**
 * A lexer (or scanner or tokenizer) for the Iota language.
 */
public interface IotaLexer extends Iterator<IotaToken> {
  /**
   * Returns the next token in the input.
   * 
   * @throws IotaCompilationException if there is a lexical error
   * @throws NoSuchElementException if there are no more tokens in the input
   */
  public IotaToken next() throws IotaCompilationException, NoSuchElementException;
  
  /**
   * This operation is not supported.
   * 
   * @throws UnsupportedOperationException whenever invoked
   */
  public void remove();
}
