package edu.cornell.cs.cs4120.iota;

/**
 * An exception indicating an invalid Iota program.
 */
public class IotaCompilationException extends RuntimeException {
  private static final long serialVersionUID = 1L;
  
  private final Position position;

  /**
   * Constructs a generic compilation exception indicating offending code at the
   * given position.
   * 
   * @param position
   *          the position of the code causing this compilation exception
   */
  public IotaCompilationException(Position position) {
    super("Generic ompilation error.");
    this.position = position;
  }

  /**
   * Constructs a compilation exception indicating offending code at the given
   * position with the given message as a reason.
   * 
   * @param message
   *          the reason for this compilation exception
   * @param position
   *          the position of the code causing this compilation exception
   */
  public IotaCompilationException(String message, Position position) {
    super(message);
    this.position = position;
  }

  /**
   * Returns the position in the offending Iota code.
   * 
   * @return the position of the offending Iota code
   */
  public final Position getPosition() {
    return position;
  }
  
  /**
   * Returns a human-friendly representation of this exception, including the
   * compilation unit (if available), the line number, and the error message.
   * 
   * @return a human-friendly representation of this compilation exception
   */
  @Override
  public String toString() {
    if (position.unit() != null) {
      return String.format("%s: %s:%d: %s", getClass().getSimpleName(),
          position.unit(), position.lineStart(), getMessage());
    } else {
      return String.format("%s: line %d: %s", getClass().getSimpleName(),
          position.lineStart(), getMessage());
    }
  }
}
