package edu.cornell.cs.cs4120.iota;

import edu.cornell.cs.cs4120.util.VisualizableTreeNode;

/**
 * Abstract syntax tree node for representing an Iota program.
 */
public interface IotaAbstractSyntaxNode extends VisualizableTreeNode {
  /**
   * The source file position where this node occurs.
   *
   * <p>The start of the position should be the start of the leftmost token in
   * this node, and the end of the position should be the end of the rightmost
   * token in this node.
   *
   * <p>This is useful for error reporting.
   *
   * @return the position of this node
   */
  Position position();
}
