package example;
import java_cup.runtime.Symbol;

%%

%public
%class Lexer
%type Symbol
%function nextToken

%{
    void print() {
	System.err.println("Created token: " + yytext());
    }
%}

Whitespace = [ \t\f\r\n]
Integer = [1-9][0-9]*

%eofval{
  return new Symbol(sym.EOF);
%eofval}

%%

{Whitespace}  { /* ignore */ }
{Integer}     { print(); return new Symbol(sym.NUMBER,
				          new Number(Integer.parseInt(yytext()))); }
"(" 	      { print(); return new Symbol(sym.LPAREN); }
")" 	      { print(); return new Symbol(sym.RPAREN); }
"+" 	      { print(); return new Symbol(sym.PLUS); }
"*" 	      { print(); return new Symbol(sym.TIMES); }
"=" 	      { print(); return new Symbol(sym.EQUALS); }
"if"          { print(); return new Symbol(sym.IF); }
"then"        { print(); return new Symbol(sym.THEN); }
"else"        { print(); return new Symbol(sym.ELSE); }
.|\n          { print(); }
