// LLAnalyze -- Nathaniel Nystrom, February 2000
// For use in Cornell University Computer Science 412/413

// Class representing tokens returned by Yylex.

package Iota.util.grammar;

public class Yytoken
{
    int index;
    int line;
    String text;

    public Yytoken(int index, int line)
    {
	this.index = index;
	this.line = line;
	this.text = "";
    }

    public Yytoken(int index, int line, String text)
    {
	this.index = index;
	this.line = line;
	this.text = text;
    }

    public String toString()
    {
	return "\"" + text + "\"";
    }

    public static final int COLON = 257;
    public static final int ID = 258;
    public static final int LBRACKET = 259;
    public static final int LPAREN = 260;
    public static final int OR = 261;
    public static final int PLUS = 262;
    public static final int RBRACKET = 263;
    public static final int RPAREN = 264;
    public static final int SEMI = 265;
    public static final int SEPSEP = 266;
    public static final int SEPSTART = 267;
    public static final int SEPTOKEN = 268;
    public static final int STAR = 269;
}
