// LLAnalyze -- Nathaniel Nystrom, February 2000
// For use in Cornell University Computer Science 412/413

// Abstract class for symbol expressions in the grammar
// (terminals and nonterminals).

package Iota.util.grammar;

import java.util.*;

public class Symbol extends Expr
{
    String sym;
    int index;

    public Symbol(String sym, int index)
    {
	this.sym = sym;
	this.index = index;
    }

    public int getIndex()
    {
	return index;
    }

    public String getString()
    {
	return sym;
    }

    public String toString()
    {
	return sym;
    }

    public boolean equals(Object o)
    {
	return o instanceof Symbol &&
	       sym != null &&
	       sym.equals(((Symbol) o).sym) &&
	       index == ((Symbol) o).index;
    }

    public int hashCode()
    {
        return sym.hashCode() + index;
    }
}
