// LLAnalyze -- Nathaniel Nystrom, February 2000
// For use in Cornell University Computer Science 412/413

// Class representing rules in a context-free grammar.  The LHS is a
// nonterminal and the RHS is a list of expressions.

package Iota.util.grammar;

import java.util.*;

public class Rule
{
    Nonterminal left;
    List right;

    public Rule(Nonterminal left, List right)
    {
	this.left = left;
	this.right = right;
    }

    public Nonterminal getLHS()
    {
	return left;
    }

    public List getRHS()
    {
	return right;
    }

    public String toString()
    {
	String s = left + " :";

	Iterator it = right.iterator();

	while (it.hasNext()) {
	    Expr expr = (Expr) it.next();
	    s += " " + expr;
	}

	return s + " ;";
    }
}
