#!/bin/sh

PATH=.:$PATH
mod_ext=".im"
timeout=120

# Turn on echoing of commands
#set -x

if [ ! -f iota.lib ]
then
	echo iota.lib not found
	exit 1
fi

if [ ! -f iotaextra.lib ]
then
	echo iotaextra.lib not found
	exit 1
fi

if [ ! -f $IOTAC/Iota/Compiler.class ]
then
	echo $IOTAC/Iota/Compiler.class not found
	exit 1
fi

tests=${*-"*.test"}
log="$CS412_GROUP.txt"

rm -f $log

for i in $tests
do
	k=`echo $i | sed 's/\.test$//'`

	if [ ! -f $k.test ]
	then
		echo $k.test not found
		continue
	fi

	echo | tee -a $log
	echo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ \
		| tee -a $log
	echo +++ Test: $k +++ | tee -a $log
	#echo Press any key to continue...
	#read dummy

	main=`grep MAIN $k.test | sed 's/MAIN *//'`
	other=`grep OTHER $k.test | sed 's/OTHER *//'`
	run=`grep RUN $k.test | sed 's/RUN *//'`
	cpp=`grep CPP $k.test | sed 's/CPP *//'`
	java=`grep JAVA $k.test | sed 's/JAVA *//'`

	if [ "x$run" = "x" ]
	then
		run=$main
	fi

	if [ "x$main" = "x" ]
	then
		echo MAIN not found in $k.test
		continue
	fi

	ok=1

	for m in $main $other
	do
		if [ ! -f $m$mod_ext ]
		then
			ok=0
			echo +++ $m$mod_ext not found +++
			continue
		fi

		rm -f $m.asm $m.obj $m.exe
	done

	if [ $ok -eq 0 ]
	then
		continue
	fi

	ok=1

	for m in $main $other
	do
		echo +++ Compiling $m$mod_ext +++ | tee -a $log
		expect timeout $timeout \
			time -f "+++ Compile time: %E +++" -o $m.compile.time \
			java -cp "$IOTAC;java_cup.jar" \
			Iota.Compiler $IOTAC_FLAGS $m$mod_ext 2>&1 >$m.compile.out

	        if [ $? -eq 99 ]
	        then
			echo +++ Compile failed +++ | tee -a $log
			echo "+++ Time limit ($timeout sec.) exceeded +++" | tee -a $log
			ok = 0
			continue
		else
			cat $m.compile.time | grep "+++.*" | tee -a $log
        	fi

	        cat $m.compile.out | tee -a $log
        	rm -f $m.compile.out

		if [ ! -f $m.asm ]
		then
			echo +++ Compile failed +++  | tee -a $log
			echo +++ $m.asm not found +++ | tee -a $log
			ok=0
			continue
		fi

		echo +++ Assembling $m.asm +++ | tee -a $log
		ml /nologo /c /coff /Zi /Zd $m.asm 2>&1 >$m.asm.out

		if [ ! -f $m.obj ]
		then
			cat $m.asm.out | tee -a $log
			echo +++ ml failed +++ | tee -a $log
			echo +++ $m.obj not found +++ | tee -a $log
			ok=0
			continue
		fi
	done

  	if [ $ok -eq 0 ]
	then
		continue
	fi

	obj=
	mod=
	for m in $main $other
	do
		obj="$obj $m.obj"
		mod="$mod $m.im"
	done

	rm -f iota0.asm iota0.obj

	echo +++ Prelinking $mod +++ | tee -a $log
	java -cp Iota0.jar Iota.Prelinker -output iota0.asm $mod

	if [ ! -f iota0.asm ]
	then
		echo +++ Prelinker failed +++ | tee -a $log
		echo +++ iota0.asm not found +++ | tee -a $log
		continue
	fi

	echo +++ Assembling iota0.asm +++ | tee -a $log
	ml /nologo /c /coff /Zi /Zd iota0.asm 2>&1 >iota0.asm.out

	if [ ! -f iota0.obj ]
	then
		cat iota0.asm.out | tee -a $log
		echo +++ ml failed +++ | tee -a $log
		echo +++ iota0.obj not found +++ | tee -a $log
		continue
	fi

	echo +++ Linking $obj iota0.obj iota.lib iotaextra.lib +++
	link /nologo /pdb:none /debug /debugtype:coff \
		$obj iota0.obj iota.lib iotaextra.lib

	if [ ! -f $main.exe ]
	then
		echo +++ link failed +++ | tee -a $log
		echo +++ $main.exe not found +++ | tee -a $log
		continue
	fi

	rm -f $main.iota.out

	echo +++ Running ./$main $run +++
	expect timeout $timeout \
		time -f "+++ Run time: %E +++" -o $m.run.time \
		./$main $run 2>&1 >$main.iota.out

	if [ $? -eq 99 ]
	then
		echo +++ Run failed +++ | tee -a $log
		echo +++ Time limit exceeded +++ | tee -a $log
		continue
	else
		cat $m.run.time | grep "+++.*" | tee -a $log
	fi

	if [ ! -f $main.iota.out ]
	then
		echo +++ Run failed +++ | tee -a $log
		echo +++ $main.iota.out not found +++ | tee -a $log
		continue
	fi

	#cat $main.iota.out | tee -a $log

	echo +++ Diffing output +++
	diff -q -w $main.iota.out $main.out

	if [ $? -eq 0 ]
	then
		echo +++ Output is correct +++ | tee -a $log
	else
		echo +++ Output is incorrect +++ | tee -a $log
	fi

done

