/*
 * Decompiled with CFR 0.152.
 */
package Iota.X86Backend;

import Iota.AAsm.AABinary;
import Iota.AAsm.AACall;
import Iota.AAsm.AADiv;
import Iota.AAsm.AAImmediate;
import Iota.AAsm.AAJump;
import Iota.AAsm.AALabel;
import Iota.AAsm.AAMem;
import Iota.AAsm.AAMemTemp;
import Iota.AAsm.AAMod;
import Iota.AAsm.AAMove;
import Iota.AAsm.AAMul;
import Iota.AAsm.AAReg;
import Iota.AAsm.AATemp;
import Iota.AAsm.AAUnary;
import Iota.BackendAssembler;
import Iota.IotaSystem;
import java.io.PrintWriter;
import java.util.Vector;

public class MasmBackend
implements BackendAssembler {
    private PrintWriter pw_ = null;

    public void postamble() {
        this.pw_.println("END");
    }

    public void setOutputWriter(PrintWriter pw) {
        this.pw_ = pw;
    }

    public PrintWriter getOutputWriter() {
        return this.pw_;
    }

    public void prolog(String mangledFunctionName, int frameSize, Vector calleeSaved) {
        this.pw_.println(mangledFunctionName + " PROC NEAR");
        this.pw_.println("PUSH EBP");
        this.pw_.println("MOV EBP, ESP");
        this.pw_.println("  ;allocating locals space of " + String.valueOf(-frameSize) + " bytes.");
        this.pw_.println("SUB ESP, " + String.valueOf(-frameSize));
        int i = 0;
        while (i < calleeSaved.size()) {
            AAReg r = (AAReg)calleeSaved.elementAt(i);
            this.pw_.println("PUSH " + AAReg.regs[r.getReg()]);
            ++i;
        }
    }

    public void dataElement(String s) {
        this.pw_.println(s);
    }

    public void epilog(String mangledFunctionName, int frameSize, Vector calleeSaved) {
        int i = calleeSaved.size() - 1;
        while (i >= 0) {
            AAReg r = (AAReg)calleeSaved.elementAt(i);
            this.pw_.println("POP " + AAReg.regs[r.getReg()]);
            --i;
        }
        this.pw_.println("LEAVE");
        this.pw_.println("RET");
        this.pw_.println(mangledFunctionName + " ENDP");
    }

    public void codeSegmentEnd() {
        this.pw_.println("_TEXT ENDS");
    }

    public void dataSegmentEnd() {
        this.pw_.println("_DATA ENDS");
    }

    public void outputInstructionString(String s) {
        this.pw_.println(s);
    }

    public String stringifyCall(AACall o) {
        return "CALL " + o.getFunc();
    }

    public String stringifyMemValue(AAMem o) {
        AAImmediate offset = o.getOffset();
        if (offset == null) {
            return "DWORD PTR [" + o.getBase() + "]";
        }
        String s = "DWORD PTR [" + o.getBase();
        s = offset.toString().startsWith("-") ? s + " " + offset.toString() : s + " + " + offset.toString();
        s = s + "]";
        return s;
    }

    public String stringifyMul(AAMul o) {
        return "IMUL " + o.opParams[0];
    }

    public void preambleExtra() {
        this.pw_.println("EXTERN _iota__stringsub:NEAR");
    }

    public void flush() {
        this.pw_.flush();
    }

    public void preamble(String moduleName) {
        this.pw_.println("TITLE " + moduleName + ".mod");
        this.pw_.println(".586");
        this.pw_.println(".model FLAT");
        this.pw_.println("");
        this.pw_.println("EXTERN _iota__debug:NEAR");
        this.pw_.println("EXTERN _iota__malloc:NEAR");
        this.pw_.println("EXTERN _iota__abort:NEAR");
        this.pw_.println("EXTERN _iota__newstring:NEAR");
        this.pw_.println("EXTERN _iota__newarray:NEAR");
        this.pw_.println("EXTERN _iota__strcompare:NEAR");
        this.pw_.println("EXTERN _iota__strconcat:NEAR");
        this.pw_.println("");
    }

    public void codeSegmentBegin() {
        this.pw_.println("_TEXT SEGMENT");
    }

    public void dataSegmentBegin() {
        this.pw_.println("_DATA SEGMENT");
    }

    public String stringifyImmediateValue(AAImmediate o) {
        return o.getImmediate();
    }

    public String stringifyTempValue(AATemp o) {
        return o.getName();
    }

    public String offsetArg(String id) {
        return "OFFSET FLAT:" + id;
    }

    public void outputExternalName(String mangledName) {
        this.pw_.println("EXTERN " + mangledName + ":NEAR");
    }

    public String stringifyMod(AAMod o) {
        return "IDIV " + o.opParams[0];
    }

    public String stringifyLabel(AALabel o) {
        return o.getName() + ":";
    }

    public String stringifyJump(AAJump o) {
        return o.getOpcode() + " " + o.getLabel();
    }

    public String stringifyMove(AAMove o) {
        return "MOV " + o.opParams[0] + ", " + o.opParams[1];
    }

    public String stringifyMemTempValue(AAMemTemp o) {
        return "DWORD [" + o.getName() + "]";
    }

    public String stringifyBinary(AABinary o) {
        return o.getOpcode() + " " + o.opParams[0] + ", " + o.opParams[1];
    }

    public String stringifyDiv(AADiv o) {
        return "IDIV " + o.opParams[0];
    }

    public String stringifyUnary(AAUnary o) {
        return o.getOpcode() + " " + o.opParams[0];
    }

    public String stringifyRegValue(AAReg o) {
        return AAReg.regs[o.getReg()];
    }

    public String mangle(String module, String id) {
        if (id.equals(IotaSystem.moduleInitFunc)) {
            return "_" + module + id;
        }
        if (id.equals("main")) {
            return "_iota__main";
        }
        return "_" + module + "__" + id;
    }

    public void outputPublicName(String mangledName) {
        this.pw_.println("PUBLIC " + mangledName);
    }
}

