/*
 * Decompiled with CFR 0.152.
 */
package Iota;

import Iota.AAsm.AACall;
import Iota.AAsm.AAImmediate;
import Iota.AAsm.AAInstr;
import Iota.BackendAssembler;
import Iota.IotaSystem;
import Iota.X86Backend.MasmBackend;
import Iota.X86Backend.NasmBackend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class Prelinker {
    private boolean verbose_;
    private String outFile_;
    private BackendAssembler ba_;
    private String[] files_;

    Prelinker(boolean verbose, String outFile, BackendAssembler ba, String[] files) {
        this.verbose_ = verbose;
        this.outFile_ = outFile;
        this.ba_ = ba;
        this.files_ = files;
    }

    protected String moduleNameFromFileName(String objectFileName) {
        String shortName = new File(objectFileName).getName();
        int extIndex = shortName.indexOf(46);
        if (extIndex == -1) {
            return shortName;
        }
        return shortName.substring(0, extIndex);
    }

    public static void main(String[] argv) {
        boolean verbose = false;
        boolean masmBack = true;
        String outFile = null;
        int i = 0;
        i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-v")) {
                verbose = true;
            } else if (argv[i].equals("-Nasm")) {
                masmBack = false;
            } else {
                if (!argv[i].startsWith("-output")) break;
                if (argv[i].equals("-output")) {
                    if (++i == argv.length || argv[i] == null || argv[i].equals("")) break;
                    outFile = argv[i];
                } else {
                    outFile = argv[i].substring(7);
                }
            }
            ++i;
        }
        if (i == argv.length) {
            System.out.println("Usage: Iota.Prelinker [-Nasm] [-v] [-output file] files...");
            System.exit(1);
        } else {
            String[] files = new String[argv.length - i];
            int j = 0;
            while (i < argv.length) {
                files[j] = argv[i];
                ++i;
                ++j;
            }
            if (masmBack) {
                IotaSystem.setBackendAssembler(new MasmBackend());
            } else {
                IotaSystem.setBackendAssembler(new NasmBackend());
            }
            Prelinker p = new Prelinker(verbose, outFile, IotaSystem.getBackendAssembler(), files);
            p.run();
        }
    }

    public void run() {
        if (this.verbose_) {
            System.out.println("Iota Prelinker starting...");
        }
        OutputStream os = null;
        if (this.outFile_ == null) {
            os = System.out;
            if (this.verbose_) {
                System.out.println("No output file specified, will use stdout...");
            }
        } else {
            try {
                os = new FileOutputStream(this.outFile_);
            }
            catch (IOException exn) {
                System.err.println(exn.toString());
                System.err.println("Going to produce output on stdout...");
                os = System.out;
            }
        }
        this.ba_.setOutputWriter(new PrintWriter(os));
        this.ba_.preamble(this.outFile_ == null ? "iota1.asm" : this.outFile_);
        this.ba_.outputPublicName(this.ba_.mangle("iota", "init"));
        String[] modules = new String[this.files_.length];
        int i = 0;
        while (i < this.files_.length) {
            modules[i] = this.moduleNameFromFileName(this.files_[i]);
            ++i;
        }
        i = 0;
        while (i < modules.length) {
            this.ba_.outputExternalName(this.ba_.mangle(modules[i], IotaSystem.moduleInitFunc));
            ++i;
        }
        this.ba_.codeSegmentBegin();
        this.ba_.prolog(this.ba_.mangle("iota", "init"), 0, new Vector());
        i = 0;
        while (i < modules.length) {
            AAImmediate lbl = new AAImmediate(IotaSystem.mangle(modules[i], IotaSystem.moduleInitFunc));
            AACall code = new AACall(lbl);
            this.ba_.outputInstructionString(((AAInstr)code).toString());
            ++i;
        }
        this.ba_.epilog(this.ba_.mangle("iota", "init"), 0, new Vector());
        this.ba_.codeSegmentEnd();
        this.ba_.postamble();
        this.ba_.flush();
        if (this.verbose_) {
            System.out.println("...done");
        }
    }
}

