/*
 * Decompiled with CFR 0.152.
 */
package Iota;

import Iota.BackendAssembler;
import Iota.SymTab;
import Iota.TableEntry;
import java.util.Enumeration;
import java.util.Hashtable;

class DataSegment {
    Hashtable tbl = new Hashtable();
    private static int ctr = 0;

    public void output(BackendAssembler ba) {
        ba.dataSegmentBegin();
        Enumeration e = this.tbl.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.tbl.get(key);
            if (!(val instanceof String)) continue;
            ba.dataElement((String)this.tbl.get(key));
        }
        ba.dataSegmentEnd();
    }

    public void populateFromSymTab(SymTab tab) {
        SymTab tmp = tab;
        while (tmp != null) {
            Enumeration e = tmp.elements();
            while (e.hasMoreElements()) {
                TableEntry te = (TableEntry)e.nextElement();
                if (!te.getIsGlobal() || !te.getIsExtern()) continue;
                this.addExtern(te.getMangledName());
            }
            tmp = tmp.parent;
        }
    }

    public String addExtern(String globalName) {
        this.tbl.put(globalName, new Integer(42));
        return globalName;
    }

    private void addPair(String label, String value) {
        this.tbl.put(label, value);
    }

    public boolean contains(String varname) {
        return this.tbl.containsKey(varname);
    }

    public String addGlobal(String globalName) {
        this.addPair(globalName, globalName + " DD 00000000H");
        return globalName;
    }

    public String addString(String stringConst) {
        String myName = "str" + String.valueOf(ctr++);
        String myRep = "DD " + String.valueOf(1 + stringConst.length());
        myRep = myRep + "\n" + myName + "\tDB ";
        int i = 0;
        while (i < stringConst.length()) {
            myRep = myRep + stringConst.charAt(i);
            myRep = i % 16 == 15 ? myRep + "\n\tDB " : myRep + ",";
            ++i;
        }
        myRep = myRep + "00h";
        int extraNulls = 3 - (stringConst.length() + 4) % 4;
        int i2 = 0;
        while (i2 < extraNulls) {
            myRep = myRep + ",00h";
            ++i2;
        }
        this.addPair(myName, myRep);
        return myName;
    }
}

