/*
 * Decompiled with CFR 0.152.
 */
package Iota.AAsm;

import Iota.AAsm.AABinary;
import Iota.AAsm.AACall;
import Iota.AAsm.AAContainer;
import Iota.AAsm.AADiv;
import Iota.AAsm.AAImmediate;
import Iota.AAsm.AAInstr;
import Iota.AAsm.AAInstrs;
import Iota.AAsm.AAMem;
import Iota.AAsm.AAMemTemp;
import Iota.AAsm.AAMod;
import Iota.AAsm.AAMove;
import Iota.AAsm.AAMul;
import Iota.AAsm.AAReg;
import Iota.AAsm.AATemp;
import Iota.AAsm.AAUnary;
import Iota.AAsm.Temps;
import java.util.Vector;

public class RegisterAllocator {
    AAInstrs code;
    int frameSize;
    Vector calleeSave;

    public AAInstrs process() {
        AAInstrs result = new AAInstrs();
        Temps temps = new Temps(this.frameSize);
        this.code.reset();
        while (this.code.hasMore()) {
            int newReg;
            int genRegNum;
            int offset;
            AAContainer arg;
            AAInstr instr = this.code.getNext();
            AAInstrs loads = new AAInstrs();
            AAInstrs operation = new AAInstrs();
            AAInstrs stores = new AAInstrs();
            AAContainer[] params = new AAContainer[instr.opParams.length];
            int i = 0;
            while (i < params.length) {
                params[i] = instr.opParams[i];
                ++i;
            }
            boolean[] regUsed = new boolean[AAReg.regs.length];
            int i2 = 0;
            while (i2 < AAReg.regs.length) {
                regUsed[i2] = false;
                ++i2;
            }
            i2 = 0;
            while (i2 < instr.use.length) {
                AAContainer arg2 = instr.opParams[instr.use[i2]];
                if (arg2 instanceof AAReg) {
                    regUsed[((AAReg)arg2).getReg()] = true;
                }
                ++i2;
            }
            boolean[] regDefed = new boolean[AAReg.regs.length];
            int i3 = 0;
            while (i3 < AAReg.regs.length) {
                regDefed[i3] = false;
                ++i3;
            }
            i3 = 0;
            while (i3 < instr.def.length) {
                arg = instr.opParams[instr.def[i3]];
                if (arg instanceof AAReg) {
                    regDefed[((AAReg)arg).getReg()] = true;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < instr.use.length) {
                arg = instr.opParams[instr.use[i3]];
                if (arg instanceof AATemp) {
                    offset = temps.getOffset(((AATemp)arg).getName());
                    genRegNum = 0;
                    while (regUsed[AAReg.genRegs[genRegNum]]) {
                        ++genRegNum;
                    }
                    regUsed[genRegNum] = true;
                    if (arg instanceof AAMemTemp) {
                        newReg = 0;
                        while (regUsed[AAReg.genRegs[newReg]]) {
                            ++newReg;
                        }
                        loads.append(new AAMove(new AAReg(AAReg.genRegs[newReg]), new AAMem(new AAReg(6), new AAImmediate(offset))));
                        loads.append(new AAMove(new AAReg(AAReg.genRegs[genRegNum]), new AAMem(new AAReg(AAReg.genRegs[newReg]))));
                    } else {
                        loads.append(new AAMove(new AAReg(AAReg.genRegs[genRegNum]), new AAMem(new AAReg(6), new AAImmediate(offset))));
                    }
                    params[instr.use[i3]] = new AAReg(AAReg.genRegs[genRegNum]);
                } else {
                    params[instr.use[i3]] = instr.opParams[instr.use[i3]];
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < instr.def.length) {
                arg = instr.opParams[instr.def[i3]];
                if (arg instanceof AATemp) {
                    offset = temps.getOffset(((AATemp)arg).getName());
                    if (params[instr.def[i3]] instanceof AAReg) {
                        int newReg2 = 0;
                        while (regUsed[AAReg.genRegs[newReg2]]) {
                            ++newReg2;
                        }
                        if (arg instanceof AAMemTemp) {
                            stores.append(new AAMove(new AAReg(AAReg.genRegs[newReg2]), new AAMem(new AAReg(6), new AAImmediate(offset))));
                            stores.append(new AAMove(new AAMem(new AAReg(AAReg.genRegs[newReg2])), new AAReg(((AAReg)params[instr.def[i3]]).getReg())));
                        } else {
                            stores.append(new AAMove(new AAMem(new AAReg(6), new AAImmediate(offset)), new AAReg(((AAReg)params[instr.def[i3]]).getReg())));
                        }
                    } else {
                        genRegNum = 0;
                        while (regDefed[AAReg.genRegs[genRegNum]]) {
                            ++genRegNum;
                        }
                        regDefed[genRegNum] = true;
                        params[instr.def[i3]] = new AAReg(AAReg.genRegs[genRegNum]);
                        if (arg instanceof AAMemTemp) {
                            newReg = 0;
                            while (regUsed[AAReg.genRegs[newReg]]) {
                                ++newReg;
                            }
                            stores.append(new AAMove(new AAReg(AAReg.genRegs[newReg]), new AAMem(new AAReg(6), new AAImmediate(offset))));
                            stores.append(new AAMove(new AAMem(new AAReg(AAReg.genRegs[newReg])), new AAReg(AAReg.genRegs[genRegNum])));
                        } else {
                            stores.append(new AAMove(new AAMem(new AAReg(6), new AAImmediate(offset)), new AAReg(AAReg.genRegs[genRegNum])));
                        }
                    }
                }
                ++i3;
            }
            if (instr instanceof AAMove) {
                operation.append(new AAMove(params[0], params[1]));
            } else if (instr instanceof AAUnary) {
                operation.append(new AAUnary(((AAUnary)instr).getOpcode(), params[0]));
            } else if (instr instanceof AABinary) {
                operation.append(new AABinary(((AABinary)instr).getOpcode(), params[0], params[1]));
            } else if (instr instanceof AADiv) {
                operation.append(new AADiv(params[0]));
            } else if (instr instanceof AAMod) {
                operation.append(new AAMod(params[0]));
            } else if (instr instanceof AAMul) {
                operation.append(new AAMul(params[0]));
            } else if (instr instanceof AACall) {
                operation.append(new AACall(params[0]));
            } else {
                operation.append(instr);
            }
            result.append(loads);
            result.append(operation);
            result.append(stores);
            this.pushCalleeSavedRegs(regUsed, regDefed);
        }
        this.frameSize = temps.getSize();
        return result;
    }

    public RegisterAllocator(AAInstrs code, int initFrameSize, Vector calleeSave) {
        this.code = code;
        this.frameSize = initFrameSize;
        this.calleeSave = calleeSave;
    }

    protected void pushCalleeSavedRegs(boolean[] used, boolean[] defed) {
        int i = 0;
        while (i < AAReg.regs.length) {
            if ((used[i] || defed[i]) && AAReg.isCalleeSave(i) && !this.calleeSave.contains(new AAReg(i))) {
                this.calleeSave.addElement(new AAReg(i));
            }
            ++i;
        }
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

