/*
 * Decompiled with CFR 0.152.
 */
package Iota.AAsm;

import Iota.AAsm.AAContainer;
import Iota.IotaSystem;
import Iota.PrettyPrinter.PrettyPrinter;

public class AAReg
extends AAContainer {
    private int reg;
    public static final int EAX = 0;
    public static final int EBX = 1;
    public static final int ECX = 2;
    public static final int EDX = 3;
    public static final int ESI = 4;
    public static final int EDI = 5;
    public static final int EBP = 6;
    public static final int ESP = 7;
    public static final String[] regs = new String[]{"EAX", "EBX", "ECX", "EDX", "ESI", "EDI", "EBP", "ESP"};
    public static final int[] genRegs;
    public static final int[] calleeRegs;

    public String toString() {
        return IotaSystem.getBackendAssembler().stringifyRegValue(this);
    }

    public AAReg(int r) {
        this.reg = r;
    }

    public int getReg() {
        return this.reg;
    }

    public boolean equals(Object o) {
        return o instanceof AAReg && ((AAReg)o).getReg() == this.getReg();
    }

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 1;
        nArray[4] = 4;
        nArray[5] = 5;
        genRegs = nArray;
        calleeRegs = new int[]{1, 4, 5};
    }

    public boolean isCalleeSave() {
        return AAReg.isCalleeSave(this.getReg());
    }

    public static boolean isCalleeSave(int r) {
        int i = 0;
        while (i < calleeRegs.length) {
            if (r == calleeRegs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dump(PrettyPrinter s) {
        s.write(this.toString());
    }
}

