/*
 * Decompiled with CFR 0.152.
 */
package Iota.AAsm;

import Iota.AAsm.AAContainer;
import Iota.AAsm.AAInstr;
import Iota.IotaSystem;
import Iota.PrettyPrinter.PrettyPrinter;

public class AABinary
extends AAInstr {
    public static final String ADD = "ADD";
    public static final String SUB = "SUB";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String XOR = "XOR";
    public static final String SHL = "SHL";
    public static final String SHR = "SHR";
    public static final String SAR = "SAR";
    public static final String CMP = "CMP";
    private String opcode;

    public String toString() {
        return IotaSystem.getBackendAssembler().stringifyBinary(this);
    }

    public AABinary(String opcode, AAContainer arg1, AAContainer arg2) {
        this.opcode = opcode;
        this.opParams = new AAContainer[2];
        this.opParams[0] = arg1;
        this.opParams[1] = arg2;
        this.use = new int[2];
        this.use[0] = 0;
        this.use[1] = 1;
        if (opcode.equals(CMP)) {
            this.def = new int[0];
        } else {
            this.def = new int[1];
            this.def[0] = 0;
        }
    }

    public String getOpcode() {
        return this.opcode;
    }

    public void dump(PrettyPrinter s) {
        s.begin(0);
        s.write(this.opcode);
        s.write(" ");
        s.allowBreak(2);
        this.opParams[0].dump(s);
        s.write(", ");
        s.allowBreak(2);
        this.opParams[1].dump(s);
        s.end();
        s.newline(0);
    }
}

