/*
 * Decompiled with CFR 0.152.
 */
package JLex;

final class JavaLexBitSet
implements Cloneable {
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public JavaLexBitSet() {
        this(64);
    }

    public JavaLexBitSet(int n) {
        this.bits = new long[this.nbits2size(n)];
    }

    public void and(JavaLexBitSet javaLexBitSet) {
        int n;
        int n2 = n = Math.min(this.bits.length, javaLexBitSet.bits.length);
        while (n2-- > 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & javaLexBitSet.bits[n2];
        }
        while (n < this.bits.length) {
            this.bits[n] = 0L;
            ++n;
        }
    }

    public void clear(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            this.resize(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        try {
            JavaLexBitSet javaLexBitSet = (JavaLexBitSet)super.clone();
            javaLexBitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, javaLexBitSet.bits, 0, this.bits.length);
            return javaLexBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof JavaLexBitSet) {
            int n;
            JavaLexBitSet javaLexBitSet = (JavaLexBitSet)object;
            int n2 = n = Math.min(this.bits.length, javaLexBitSet.bits.length);
            while (n2-- > 0) {
                if (this.bits[n2] == javaLexBitSet.bits[n2]) continue;
                return false;
            }
            if (this.bits.length > n) {
                int n3 = this.bits.length;
                while (n3-- > n) {
                    if (this.bits[n3] == 0L) continue;
                    return false;
                }
            } else if (javaLexBitSet.bits.length > n) {
                int n4 = javaLexBitSet.bits.length;
                while (n4-- > n) {
                    if (javaLexBitSet.bits[n4] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        return n2 < this.bits.length ? (this.bits[n2] & 1L << (n & 0x3F)) != 0L : false;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)n;
        }
        return (int)(l >> 32 ^ l);
    }

    private int nbits2size(int n) {
        return (n >> 6) + 1;
    }

    public void or(JavaLexBitSet javaLexBitSet) {
        int n = Math.min(this.bits.length, javaLexBitSet.bits.length);
        while (n-- > 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] | javaLexBitSet.bits[n];
        }
    }

    private void resize(int n) {
        int n2 = Math.max(this.bits.length, this.nbits2size(n));
        long[] lArray = new long[n2];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public void set(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            this.resize(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | 1L << (n & 0x3F);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.bits.length << 6) {
            if (this.get(n)) {
                if (string.length() > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + n;
            }
            ++n;
        }
        return "{" + string + "}";
    }

    public void xor(JavaLexBitSet javaLexBitSet) {
        int n = Math.min(this.bits.length, javaLexBitSet.bits.length);
        while (n-- > 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] ^ javaLexBitSet.bits[n];
        }
    }
}

