/*
 * Decompiled with CFR 0.152.
 */
package JLex;

import JLex.CAlloc;
import JLex.CBunch;
import JLex.CDTrans;
import JLex.CDfa;
import JLex.CLexGen;
import JLex.CNfa;
import JLex.CSpec;
import JLex.CUtility;
import JLex.JavaLexBitSet;
import java.util.Stack;
import java.util.Vector;

class CNfa2Dfa {
    private CSpec m_spec;
    private int m_unmarked_dfa;
    private CLexGen m_lexGen;
    private static final int NOT_IN_DSTATES = -1;

    CNfa2Dfa() {
        this.reset();
    }

    private int add_to_dstates(CBunch cBunch) {
        CUtility.assert(cBunch.m_nfa_set != null);
        CUtility.assert(cBunch.m_nfa_bit != null);
        CUtility.assert(cBunch.m_accept != null || cBunch.m_anchor == 0);
        CDfa cDfa = CAlloc.newCDfa(this.m_spec);
        cDfa.m_nfa_set = (Vector)cBunch.m_nfa_set.clone();
        cDfa.m_nfa_bit = (JavaLexBitSet)cBunch.m_nfa_bit.clone();
        cDfa.m_accept = cBunch.m_accept;
        cDfa.m_anchor = cBunch.m_anchor;
        cDfa.m_mark = false;
        this.m_spec.m_dfa_sets.put(cDfa.m_nfa_bit, cDfa);
        return cDfa.m_label;
    }

    private void e_closure(CBunch cBunch) {
        CNfa cNfa;
        CUtility.assert(cBunch != null);
        CUtility.assert(cBunch.m_nfa_set != null);
        CUtility.assert(cBunch.m_nfa_bit != null);
        cBunch.m_accept = null;
        cBunch.m_anchor = 0;
        cBunch.m_accept_index = Integer.MAX_VALUE;
        Stack<CNfa> stack = new Stack<CNfa>();
        int n = cBunch.m_nfa_set.size();
        int n2 = 0;
        while (n2 < n) {
            cNfa = (CNfa)cBunch.m_nfa_set.elementAt(n2);
            CUtility.assert(cBunch.m_nfa_bit.get(cNfa.m_label));
            stack.push(cNfa);
            ++n2;
        }
        while (!stack.empty()) {
            cNfa = (CNfa)stack.pop();
            if (cNfa.m_accept != null && cNfa.m_label < cBunch.m_accept_index) {
                cBunch.m_accept_index = cNfa.m_label;
                cBunch.m_accept = cNfa.m_accept;
                cBunch.m_anchor = cNfa.m_anchor;
                CUtility.assert(cBunch.m_accept != null);
                CUtility.assert(cBunch.m_anchor == 0 || (cBunch.m_anchor & 2) != 0 || (cBunch.m_anchor & 1) != 0);
            }
            if (cNfa.m_edge != -3) continue;
            if (cNfa.m_next != null && !cBunch.m_nfa_set.contains(cNfa.m_next)) {
                CUtility.assert(!cBunch.m_nfa_bit.get(cNfa.m_next.m_label));
                cBunch.m_nfa_bit.set(cNfa.m_next.m_label);
                cBunch.m_nfa_set.addElement(cNfa.m_next);
                stack.push(cNfa.m_next);
            }
            if (cNfa.m_next2 == null || cBunch.m_nfa_set.contains(cNfa.m_next2)) continue;
            CUtility.assert(!cBunch.m_nfa_bit.get(cNfa.m_next2.m_label));
            cBunch.m_nfa_bit.set(cNfa.m_next2.m_label);
            cBunch.m_nfa_set.addElement(cNfa.m_next2);
            stack.push(cNfa.m_next2);
        }
        if (cBunch.m_nfa_set != null) {
            this.sortStates(cBunch.m_nfa_set);
        }
    }

    private void free_dfa_states() {
        this.m_spec.m_dfa_states = null;
        this.m_spec.m_dfa_sets = null;
    }

    private void free_nfa_states() {
        this.m_spec.m_nfa_states = null;
        this.m_spec.m_nfa_start = null;
        this.m_spec.m_state_rules = null;
    }

    private CDfa get_unmarked() {
        int n = this.m_spec.m_dfa_states.size();
        while (this.m_unmarked_dfa < n) {
            CDfa cDfa = (CDfa)this.m_spec.m_dfa_states.elementAt(this.m_unmarked_dfa);
            if (!cDfa.m_mark) {
                boolean cfr_ignored_0 = this.m_spec.m_verbose;
                if (false) {
                    System.out.println("---------------");
                    System.out.print("working on DFA state " + this.m_unmarked_dfa + " = NFA states: ");
                    this.m_lexGen.print_set(cDfa.m_nfa_set);
                    System.out.print("\n");
                }
                return cDfa;
            }
            ++this.m_unmarked_dfa;
        }
        return null;
    }

    private int in_dstates(CBunch cBunch) {
        CDfa cDfa = (CDfa)this.m_spec.m_dfa_sets.get(cBunch.m_nfa_bit);
        if (cDfa != null) {
            return cDfa.m_label;
        }
        return -1;
    }

    void make_dfa(CLexGen cLexGen, CSpec cSpec) {
        this.reset();
        this.set(cLexGen, cSpec);
        this.make_dtrans();
        this.free_nfa_states();
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        if (false) {
            System.out.println(String.valueOf(this.m_spec.m_dfa_states.size()) + " DFA states in original machine.");
        }
        this.free_dfa_states();
    }

    private void make_dtrans() {
        System.out.print("Working on DFA states.");
        CBunch cBunch = new CBunch();
        this.m_unmarked_dfa = 0;
        int n = this.m_spec.m_state_rules.length;
        this.m_spec.m_state_dtrans = new int[n];
        int n2 = 0;
        while (n > n2) {
            if (this.m_spec.m_state_rules[n2].size() == 0) {
                this.m_spec.m_state_dtrans[n2] = -1;
            } else {
                CDfa cDfa;
                cBunch.m_nfa_set = (Vector)this.m_spec.m_state_rules[n2].clone();
                this.sortStates(cBunch.m_nfa_set);
                cBunch.m_nfa_bit = new JavaLexBitSet();
                int n3 = cBunch.m_nfa_set.size();
                int n4 = 0;
                while (n3 > n4) {
                    CNfa cNfa = (CNfa)cBunch.m_nfa_set.elementAt(n4);
                    cBunch.m_nfa_bit.set(cNfa.m_label);
                    ++n4;
                }
                cBunch.m_accept = null;
                cBunch.m_anchor = 0;
                cBunch.m_accept_index = Integer.MAX_VALUE;
                this.e_closure(cBunch);
                this.add_to_dstates(cBunch);
                this.m_spec.m_state_dtrans[n2] = this.m_spec.m_dtrans_vector.size();
                while ((cDfa = this.get_unmarked()) != null) {
                    System.out.print(".");
                    System.out.flush();
                    CUtility.assert(!cDfa.m_mark);
                    cDfa.m_mark = true;
                    CDTrans cDTrans = new CDTrans(this.m_spec.m_dtrans_vector.size(), this.m_spec);
                    cDTrans.m_accept = cDfa.m_accept;
                    cDTrans.m_anchor = cDfa.m_anchor;
                    n4 = 0;
                    while (n4 < this.m_spec.m_dtrans_ncols) {
                        int n5;
                        CUtility.assert(n4 >= 0);
                        CUtility.assert(this.m_spec.m_dtrans_ncols > n4);
                        this.move(cDfa.m_nfa_set, cDfa.m_nfa_bit, n4, cBunch);
                        if (cBunch.m_nfa_set != null) {
                            this.e_closure(cBunch);
                        }
                        CUtility.assert(cBunch.m_nfa_set == null && cBunch.m_nfa_bit == null || cBunch.m_nfa_set != null && cBunch.m_nfa_bit != null);
                        if (cBunch.m_nfa_set == null) {
                            n5 = -1;
                        } else {
                            n5 = this.in_dstates(cBunch);
                            if (n5 == -1) {
                                n5 = this.add_to_dstates(cBunch);
                            }
                        }
                        CUtility.assert(n5 < this.m_spec.m_dfa_states.size());
                        cDTrans.m_dtrans[n4] = n5;
                        ++n4;
                    }
                    CUtility.assert(this.m_spec.m_dtrans_vector.size() == cDfa.m_label);
                    this.m_spec.m_dtrans_vector.addElement(cDTrans);
                }
            }
            ++n2;
        }
        System.out.println("");
    }

    void move(Vector vector, JavaLexBitSet javaLexBitSet, int n, CBunch cBunch) {
        cBunch.m_nfa_set = null;
        cBunch.m_nfa_bit = null;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            CNfa cNfa = (CNfa)vector.elementAt(n3);
            if (n == cNfa.m_edge || cNfa.m_edge == -1 && cNfa.m_set.contains(n)) {
                if (cBunch.m_nfa_set == null) {
                    CUtility.assert(cBunch.m_nfa_bit == null);
                    cBunch.m_nfa_set = new Vector();
                    cBunch.m_nfa_bit = new JavaLexBitSet();
                }
                cBunch.m_nfa_set.addElement(cNfa.m_next);
                cBunch.m_nfa_bit.set(cNfa.m_next.m_label);
            }
            ++n3;
        }
        if (cBunch.m_nfa_set != null) {
            CUtility.assert(cBunch.m_nfa_bit != null);
            this.sortStates(cBunch.m_nfa_set);
        }
    }

    private void reset() {
        this.m_lexGen = null;
        this.m_spec = null;
        this.m_unmarked_dfa = 0;
    }

    private void set(CLexGen cLexGen, CSpec cSpec) {
        this.m_lexGen = cLexGen;
        this.m_spec = cSpec;
        this.m_unmarked_dfa = 0;
    }

    private void sortStates(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            CNfa cNfa = (CNfa)vector.elementAt(n2);
            int n3 = cNfa.m_label;
            int n4 = n2;
            int n5 = n2 + 1;
            while (n5 < n) {
                cNfa = (CNfa)vector.elementAt(n5);
                int n6 = cNfa.m_label;
                if (n6 < n3) {
                    n4 = n5;
                    n3 = n6;
                }
                ++n5;
            }
            CNfa cNfa2 = (CNfa)vector.elementAt(n2);
            cNfa = (CNfa)vector.elementAt(n4);
            vector.setElementAt(cNfa, n2);
            vector.setElementAt(cNfa2, n4);
            ++n2;
        }
    }
}

