package Iota;

import java_cup.runtime.Symbol;
import java.io.*;

public class Token implements LexerResult {

    private Symbol symbol;
    private String filename;
    private int lineno;
    private Object value;	// String, Boolean, Integer, Vector, null

    public Token (String filename, int lineno, Object value) {
		this (-1, filename, lineno, -1, -1, value);
    }

    public Token (int id, String filename, int lineno, int left, int right,
		  Object value) {
		symbol = new Symbol (id, left, right, this);
		this.filename = filename;
		this.lineno = lineno;
		this.value = value;
    }

    public int getCode () {
		return symbol.sym; 
	}
	
    public Symbol getSymbol () {
		return symbol;
	}
	
    public Object getValue () {
		return value;
	}

    public String getID () {
		switch (symbol.sym) {
		case Constant.EQ: return "EQ";
		case Constant.NEW: return "NEW";
		case Constant.LCURLY: return "LCURLY";
		case Constant.WHILE: return "WHILE";
		case Constant.PLUS: return "PLUS";
		case Constant.LSQUARE: return "LSQUARE";
		case Constant.RSQUARE: return "RSQUARE";
		case Constant.INTERFACE: return "INTERFACE";
		case Constant.FALSE_CONST: return "FALSE_CONST";
		case Constant.COLON: return "COLON";
		case Constant.STRING_CONST: return "STRING_CONST";
		case Constant.STRING_TYPE: return "STRING_TYPE";
		case Constant.TRUE_CONST: return "TRUE_CONST";
		case Constant.MINUS: return "MINUS";
		case Constant.TIMES: return "TIMES";
		case Constant.GT: return "GT";
		case Constant.RCURLY: return "RCURLY";
		case Constant.SEMI: return "SEMI";
		case Constant.MOD: return "MOD";
		case Constant.ELSE: return "ELSE";
		case Constant.COMMA: return "COMMA";
		case Constant.LPAREN: return "LPAREN";
		case Constant.EOF: return "EOF";
		case Constant.RETURN: return "RETURN";
		case Constant.STMT: return "STMT";
		case Constant.LENGTH: return "LENGTH";
		case Constant.error: return "error";
		case Constant.USES: return "USES";
		case Constant.BOOLEAN_TYPE: return "BOOLEAN_TYPE";
		case Constant.NOT: return "NOT";
		case Constant.IDENTIFIER: return "IDENTIFIER";
		case Constant.MODULE: return "MODULE";
		case Constant.RPAREN: return "RPAREN";
		case Constant.LT: return "LT";
		case Constant.ASSIGN: return "ASSIGN";
		case Constant.IF: return "IF";
		case Constant.INT_TYPE: return "INT_TYPE";
		case Constant.DOT: return "DOT";
		case Constant.AND: return "AND";
		case Constant.DIVIDE: return "DIVIDE";
		case Constant.OR: return "OR";
		case Constant.INT_CONST: return "INT_CONST";
		case Constant.ARRAY: return "ARRAY";
		case Constant.SEMIELSE: return "SEMIELSE";

		    // Iota+ stuff
		case Constant.OBJECT_TYPE: return "OBJECT_TYPE";
		case Constant.IMPLEMENTS: return "IMPLEMENTS";
		case Constant.NULL_CONST: return "NULL_CONST";
		case Constant.THIS: return "THIS";
		case Constant.CAST: return "CAST";
		case Constant.LEQ: return "LEQ";
		case Constant.GEQ: return "GEQ";
		case Constant.NEQ: return "NEQ";
		case Constant.INCREMENT: return "INCREMENT";
		case Constant.DECREMENT: return "DECREMENT";
		case Constant.BREAK: return "BREAK";

		default: break;
		}
		throw new IllegalStateException ("Unknown symbol code: " + symbol.sym);
		}

		public String toString () {
		return filename + ":" + lineno + ": \"" + value + "\"";
    }

    public void unparse (java.io.OutputStream o) {
		if (value != null) {
			try {
				o.write (value.toString ().getBytes ());
			}
			catch (IOException e) {
			}
		}
    }

    public String getFilename () {
		return filename;
	}
	
    public int lineNumber () {
		return lineno;
	}
	
	public int getLineno() {
		return lineno;
	}
	
    public void setLineno (int i) {
		lineno = i;
	}
}
