package Iota;

import java.io.*;

public class SemTest {

    private static final String dumpAST = "-dump_ast";
    private static final String noTypeCheck = "-no_typecheck";

    public static void main (String args[]) {
		if (args.length < 1) {
		    System.err.println ("Usage: java Iota.SemTest [" + 
					dumpAST + "|" +
					noTypeCheck +
					"] <filename>");
		    System.exit (1);
		}

		boolean dumpTree = false;
		boolean typecheck = true;
		boolean programIsCorrect = false;				//Always true if typechecking if off
		int i;
		for (i = 0; i < args.length; i++) {
		    String filename = args[i];
		    while (filename.charAt (0) == '-') {
				if (filename.equals (dumpAST)) {
				    dumpTree = true;
				    i++;
				}
				if (filename.equals (noTypeCheck)) {
				    typecheck = false;
				    i++;
				}
				filename = args[i];
		    }
		    try {
				FileInputStream in = null;
				try {
					in=new FileInputStream (filename);
				}
				catch (IOException e) {
					System.err.println("File "+filename+" not found.");
					System.exit(-1);
				}
				
				Parser parser = new Parser (in, filename);
				parser.parse ();
				//TODO : Modify this to get root of your AST from the Parser
				Object root=parser.getProgramNode();
				if (root==null) {
					in.close();
					System.exit(-1);
				}
				if (typecheck) {
					//TODO : Fill in your typecheck code here
					programIsCorrect=true;
				} else {
				    programIsCorrect=true;
				}
				if (dumpTree) {
					//TODO : Fill in your AST dump code here
				}
				in.close ();
		    } catch (Exception ex) { 
				System.out.println("Failed: " + ex.getMessage());
				ex.printStackTrace (); 
			}
		}
		System.exit (1);
	}
}
