package Iota;
import java.io.InputStream;


public class Lexer {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 128;
	private final int YY_EOF = 129;

private String line_separator;
private boolean errors;
private String filename;
public Lexer (InputStream in, String filename) {
    this (in);
    this.filename = filename;
    errors=false;
}
public boolean hasErrors() {
	return errors;
}
private void errorMsg (int lineno, int charno, String token,
		       String text) {
	errors=true;
    System.err.println (filename + ":" + lineno +
			": lexical error at character " + charno + 
			", \"" + token + "\": " + (text == null ? "" : text));
}
private void errorMsg (int lineno, int charno, String token) {
    errorMsg (lineno, charno, token, null);
}
private Token t (int id, Object value) {
    return new Token (id, filename, yyline + 1, yychar, yychar + yylength (),
		      value);
}
private Token t (int id) {
    return t (id, yytext ());
}
private String interp_string (String s) {
    String token = "";
    int index = 0;
    int code, i;
    while (index < s.length ()) {
		char c = s.charAt (index++);
		switch (c) {
			case '\\':
			c = s.charAt (index++);
			switch (c) {
				case 'n':
					token += '\n';
					break;
				case 'r':
					token += '\r';
					break;
				case 'N': 
					token += line_separator;
					break;
				case '^':		// "Ctrl-" codes
					c = s.charAt (index++);
					token += (char) ((int) c - 'A' + 1);
					break;
				case ' ' :
				case '\b':
				case '\n':     //Eat formatting characters
				case '\t':
				case '\r':
					while (c!='\\') {
						c=s.charAt(index++);
					}
					break;
				case '0':		//ASCII codes
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					if (index+2>s.length()) {
						System.err.println("Illegal ASCII code at line " +(yyline+1)+", ignoring");
						index+=2;
						break;
					}
					String asciiCode=c+s.substring(index,index+2);
					try {
						code=Integer.parseInt(asciiCode);
					}
					catch (NumberFormatException e) {
						System.err.println("Illegal ASCII code at line " +(yyline+1)+", ignoring");
						index+=2;
						break;
					}
					if (code>127) {
						System.err.println("Illegal ASCII code at line " +(yyline+1)+", ignoring");
						index+=2;
						break;
					}
					token += (char) code;
					index+=2;
					break;
			}
			break;
		default:
			token += c;
			break;
		}
    }
    return token;
}
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yychar;
	private int yyline;
	private boolean yy_at_bol;
	private int yy_lexical_state;

	public Lexer (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	public Lexer (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Lexer () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yychar = 0;
		yyline = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;

    line_separator = System.getProperty ("line.separator", "\n");
	}

	private boolean yy_eof_done = false;
	private final int STRINGS = 2;
	private final int YYINITIAL = 0;
	private final int COMMENT = 1;
	private final int yy_state_dtrans[] = {
		0,
		75,
		60
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ('\n' == yy_buffer[i] && !yy_last_was_cr) {
				++yyline;
			}
			if ('\r' == yy_buffer[i]) {
				++yyline;
				yy_last_was_cr=true;
			} else yy_last_was_cr=false;
		}
		yychar = yychar
			+ yy_buffer_index - yy_buffer_start;
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NO_ANCHOR,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NO_ANCHOR,
		/* 41 */ YY_NO_ANCHOR,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NO_ANCHOR,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NO_ANCHOR,
		/* 46 */ YY_NO_ANCHOR,
		/* 47 */ YY_NO_ANCHOR,
		/* 48 */ YY_NO_ANCHOR,
		/* 49 */ YY_NO_ANCHOR,
		/* 50 */ YY_NO_ANCHOR,
		/* 51 */ YY_NO_ANCHOR,
		/* 52 */ YY_NO_ANCHOR,
		/* 53 */ YY_NO_ANCHOR,
		/* 54 */ YY_NO_ANCHOR,
		/* 55 */ YY_NO_ANCHOR,
		/* 56 */ YY_NO_ANCHOR,
		/* 57 */ YY_NO_ANCHOR,
		/* 58 */ YY_NO_ANCHOR,
		/* 59 */ YY_NO_ANCHOR,
		/* 60 */ YY_NO_ANCHOR,
		/* 61 */ YY_NO_ANCHOR,
		/* 62 */ YY_NO_ANCHOR,
		/* 63 */ YY_NO_ANCHOR,
		/* 64 */ YY_NOT_ACCEPT,
		/* 65 */ YY_NO_ANCHOR,
		/* 66 */ YY_NO_ANCHOR,
		/* 67 */ YY_NO_ANCHOR,
		/* 68 */ YY_NO_ANCHOR,
		/* 69 */ YY_NOT_ACCEPT,
		/* 70 */ YY_NO_ANCHOR,
		/* 71 */ YY_NOT_ACCEPT,
		/* 72 */ YY_NO_ANCHOR,
		/* 73 */ YY_NOT_ACCEPT,
		/* 74 */ YY_NO_ANCHOR,
		/* 75 */ YY_NOT_ACCEPT,
		/* 76 */ YY_NO_ANCHOR,
		/* 77 */ YY_NOT_ACCEPT,
		/* 78 */ YY_NO_ANCHOR,
		/* 79 */ YY_NOT_ACCEPT,
		/* 80 */ YY_NO_ANCHOR,
		/* 81 */ YY_NOT_ACCEPT,
		/* 82 */ YY_NO_ANCHOR,
		/* 83 */ YY_NOT_ACCEPT,
		/* 84 */ YY_NO_ANCHOR,
		/* 85 */ YY_NOT_ACCEPT,
		/* 86 */ YY_NO_ANCHOR,
		/* 87 */ YY_NOT_ACCEPT,
		/* 88 */ YY_NO_ANCHOR,
		/* 89 */ YY_NOT_ACCEPT,
		/* 90 */ YY_NO_ANCHOR,
		/* 91 */ YY_NO_ANCHOR,
		/* 92 */ YY_NO_ANCHOR,
		/* 93 */ YY_NO_ANCHOR,
		/* 94 */ YY_NO_ANCHOR,
		/* 95 */ YY_NO_ANCHOR,
		/* 96 */ YY_NO_ANCHOR,
		/* 97 */ YY_NO_ANCHOR,
		/* 98 */ YY_NO_ANCHOR,
		/* 99 */ YY_NO_ANCHOR,
		/* 100 */ YY_NO_ANCHOR,
		/* 101 */ YY_NO_ANCHOR,
		/* 102 */ YY_NO_ANCHOR,
		/* 103 */ YY_NO_ANCHOR,
		/* 104 */ YY_NO_ANCHOR,
		/* 105 */ YY_NO_ANCHOR,
		/* 106 */ YY_NO_ANCHOR,
		/* 107 */ YY_NO_ANCHOR,
		/* 108 */ YY_NO_ANCHOR,
		/* 109 */ YY_NO_ANCHOR,
		/* 110 */ YY_NO_ANCHOR,
		/* 111 */ YY_NO_ANCHOR,
		/* 112 */ YY_NO_ANCHOR,
		/* 113 */ YY_NO_ANCHOR,
		/* 114 */ YY_NO_ANCHOR,
		/* 115 */ YY_NO_ANCHOR,
		/* 116 */ YY_NO_ANCHOR,
		/* 117 */ YY_NO_ANCHOR,
		/* 118 */ YY_NO_ANCHOR,
		/* 119 */ YY_NO_ANCHOR,
		/* 120 */ YY_NO_ANCHOR,
		/* 121 */ YY_NO_ANCHOR,
		/* 122 */ YY_NO_ANCHOR,
		/* 123 */ YY_NO_ANCHOR,
		/* 124 */ YY_NO_ANCHOR,
		/* 125 */ YY_NO_ANCHOR,
		/* 126 */ YY_NO_ANCHOR,
		/* 127 */ YY_NO_ANCHOR,
		/* 128 */ YY_NO_ANCHOR,
		/* 129 */ YY_NO_ANCHOR,
		/* 130 */ YY_NO_ANCHOR,
		/* 131 */ YY_NO_ANCHOR,
		/* 132 */ YY_NO_ANCHOR,
		/* 133 */ YY_NO_ANCHOR,
		/* 134 */ YY_NO_ANCHOR,
		/* 135 */ YY_NO_ANCHOR,
		/* 136 */ YY_NO_ANCHOR,
		/* 137 */ YY_NO_ANCHOR,
		/* 138 */ YY_NO_ANCHOR,
		/* 139 */ YY_NO_ANCHOR,
		/* 140 */ YY_NO_ANCHOR,
		/* 141 */ YY_NO_ANCHOR,
		/* 142 */ YY_NO_ANCHOR,
		/* 143 */ YY_NO_ANCHOR,
		/* 144 */ YY_NO_ANCHOR,
		/* 145 */ YY_NO_ANCHOR,
		/* 146 */ YY_NO_ANCHOR,
		/* 147 */ YY_NO_ANCHOR,
		/* 148 */ YY_NO_ANCHOR,
		/* 149 */ YY_NO_ANCHOR,
		/* 150 */ YY_NO_ANCHOR,
		/* 151 */ YY_NO_ANCHOR,
		/* 152 */ YY_NO_ANCHOR,
		/* 153 */ YY_NO_ANCHOR
	};
	private int yy_cmap[] = unpackFromString(1,130,
"56:8,55,57,29,56:2,29,56:18,49,23,48,50:2,34,30,50,36,37,32,24,35,25,38,33," +
"46,47:9,43,28,20,21,22,50,54,44:13,52,44:12,41,51,42,53,45,50,12,9,15,44,3," +
"16,8,19,4,14,26,11,17,5,10,18,44,7,2,6,1,44,27,44,13,44,39,31,40,50,56,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,154,
"0,1,2,3,4,5,6,7,8,9,10,1:3,11,1:13,12,1:7,13,14,12:13,1,12:6,15,1,16,1,17,1" +
",18,19,20,21,22,9,23,24,25,26,27,28,29,15,30,21,31,32,33,34,35,36,37,38,39," +
"40,41,42,43,44,45,46,47,48,49,50,51,52,12,53,54,55,56,57,58,59,60,61,62,63," +
"64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88," +
"89,90,91,92,93,94,95,12,96,97,98,99,100,101,102")[0];

	private int yy_nxt[][] = unpackFromString(103,58,
"1,2,138,143,65,100,144,145,146,147,148,149,150,146:2,151,152,146:3,3,4,5,6," +
"7,8,146,153,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,146,25,26,66,27," +
"10,25:2,146,25:4,10,-1:59,146,101,146:17,-1:6,146:2,-1:16,146,102:3,-1:4,14" +
"6,-1:26,29,-1:57,30,-1:57,31,-1:57,32,-1:60,33,-1:58,34,-1:35,64,-1:25,69,-" +
"1:19,69,-1:7,69,-1:29,10,-1:19,10,-1:7,10,-1:32,35,36,-1:25,146:19,-1:6,146" +
":2,-1:16,146,102:3,-1:4,146,-1:6,36:28,-1,36:28,-1,146:2,127,146:16,-1:6,14" +
"6:2,-1:16,146,102:3,-1:4,146,-1:6,77:31,79,77:25,1,68:28,-1,68:18,61,68:2,6" +
"2,68:3,63:3,-1:5,68:2,-1:22,83,-1:6,83:2,-1:8,85:2,68,83,-1,68:2,87,-1,83,-" +
"1,83,-1:11,71,-1:47,146:4,70,146:10,28,105,146:2,-1:6,146:2,-1:16,146,102:3" +
",-1:4,146,-1:51,66:2,-1:11,81:31,79,59,81:24,-1,68:28,-1,68:18,61,68:2,62,6" +
"8:3,-1:4,146:5,37,146:13,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:7,73,-1:56," +
"146:19,-1:6,146,38,-1:16,146,102:3,-1:4,146,-1:8,51,-1:55,146,39,146:17,-1:" +
"6,146:2,-1:16,146,102:3,-1:4,146,-1:5,1,58:28,77,58:2,67,58:25,-1,146:2,40," +
"146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:10,41,146:8,-1:6,146:2," +
"-1:16,146,102:3,-1:4,146,-1:6,146:2,42,146:16,-1:6,146:2,-1:16,146,102:3,-1" +
":4,146,-1:6,81:31,79,81:25,-1,146,43,146:17,-1:6,146:2,-1:16,146,102:3,-1:4" +
",146,-1:34,83,-1:6,83:2,-1:11,83,-1,68,-1:3,83,-1,83,-1,146:10,44,146:8,-1:" +
"6,146:2,-1:16,146,102:3,-1:4,146,-1:51,89:2,-1:11,146:5,45,146:13,-1:6,146:" +
"2,-1:16,146,102:3,-1:4,146,-1:6,68:19,-1:6,68:2,-1:13,68:2,-1,68:2,-1:5,68:" +
"4,-1:4,146:19,-1:6,46,146,-1:16,146,102:3,-1:4,146,-1:51,68:2,-1:11,146:12," +
"47,146:6,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146,48,146:17,-1:6,146:2," +
"-1:16,146,102:3,-1:4,146,-1:6,146:2,49,146:16,-1:6,146:2,-1:16,146,102:3,-1" +
":4,146,-1:6,146:2,50,146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:7," +
"52,146:11,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:4,53,146:14,-1:6,146" +
":2,-1:16,146,102:3,-1:4,146,-1:6,146:5,54,146:13,-1:6,146:2,-1:16,146,102:3" +
",-1:4,146,-1:6,146:18,55,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:2,56," +
"146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146,57,146:17,-1:6,146:2,-1" +
":16,146,102:3,-1:4,146,-1:6,106,146,72,146:16,-1:6,146:2,-1:16,146,102:3,-1" +
":4,146,-1:6,146:2,74,146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:6," +
"141,146:12,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146,76,146:17,-1:6,146:" +
"2,-1:16,146,102:3,-1:4,146,-1:6,146:17,140,146,-1:6,146:2,-1:16,146,102:3,-" +
"1:4,146,-1:6,146:10,78,146:8,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,80,14" +
"6:18,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:3,82,146:15,-1:6,146:2,-1" +
":16,146,102:3,-1:4,146,-1:6,146:5,118,146:13,-1:6,146:2,-1:16,146,102:3,-1:" +
"4,146,-1:6,146:2,119,146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:9," +
"84,146:9,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:13,120,146:5,-1:6,146" +
":2,-1:16,146,102:3,-1:4,146,-1:6,146:4,121,146:14,-1:6,146:2,-1:16,146,102:" +
"3,-1:4,146,-1:6,146:11,123,146:7,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,1" +
"46,86,146:17,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:10,124,146:8,-1:6" +
",146:2,-1:16,146,102:3,-1:4,146,-1:6,146:3,125,146:15,-1:6,146:2,-1:16,146," +
"102:3,-1:4,146,-1:6,128,146:18,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146" +
":11,88,146:7,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:2,129,146:16,-1:6" +
",146:2,-1:16,146,102:3,-1:4,146,-1:6,146:7,130,146:11,-1:6,146:2,-1:16,146," +
"102:3,-1:4,146,-1:6,146:11,90,146:7,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:" +
"6,146,91,146:17,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146,92,146:17,-1:6" +
",146:2,-1:16,146,102:3,-1:4,146,-1:6,146:10,93,146:8,-1:6,146:2,-1:16,146,1" +
"02:3,-1:4,146,-1:6,146:4,94,146:14,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6" +
",146:6,131,146:12,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:6,95,146:12," +
"-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:14,96,146:4,-1:6,146:2,-1:16,1" +
"46,102:3,-1:4,146,-1:6,146:5,97,146:13,-1:6,146:2,-1:16,146,102:3,-1:4,146," +
"-1:6,146:15,133,146:3,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:16,134,1" +
"46:2,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:11,135,146:7,-1:6,146:2,-" +
"1:16,146,102:3,-1:4,146,-1:6,146:2,136,146:16,-1:6,146:2,-1:16,146,102:3,-1" +
":4,146,-1:6,146:14,98,146:4,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:4," +
"137,146:14,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:5,99,146:13,-1:6,14" +
"6:2,-1:16,146,102:3,-1:4,146,-1:6,146:5,103,146:13,-1:6,146:2,-1:16,146,102" +
":3,-1:4,146,-1:6,146:6,122,146:12,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6," +
"146:10,142,146:8,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:3,126,146:15," +
"-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:2,132,146:16,-1:6,146:2,-1:16," +
"146,102:3,-1:4,146,-1:6,146:10,104,146:8,-1:6,146:2,-1:16,146,102:3,-1:4,14" +
"6,-1:6,146:6,107,146:11,108,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:2," +
"109,146:16,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:6,110,146:2,111,146" +
":9,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:8,112,146:10,-1:6,146:2,-1:" +
"16,146,102:3,-1:4,146,-1:6,146:2,113,146:16,-1:6,146:2,-1:16,146,102:3,-1:4" +
",146,-1:6,146:6,139,146:12,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:10," +
"114,115,146:7,-1:6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:11,116,146:7,-1:" +
"6,146:2,-1:16,146,102:3,-1:4,146,-1:6,146:18,117,-1:6,146:2,-1:16,146,102:3" +
",-1:4,146,-1:5");

	public Token getToken ()
		throws java.io.IOException {
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {

    return t (Constant.EOF, null);
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -3:
						break;
					case 3:
						{ return t (Constant.LT); }
					case -4:
						break;
					case 4:
						{ return t (Constant.ASSIGN); }
					case -5:
						break;
					case 5:
						{ return t (Constant.GT); }
					case -6:
						break;
					case 6:
						{ return t (Constant.NOT); }
					case -7:
						break;
					case 7:
						{ return t (Constant.PLUS); }
					case -8:
						break;
					case 8:
						{ return t (Constant.MINUS); }
					case -9:
						break;
					case 9:
						{ return t (Constant.SEMI); }
					case -10:
						break;
					case 10:
						{}
					case -11:
						break;
					case 11:
						{ return t (Constant.AND); }
					case -12:
						break;
					case 12:
						{ return t (Constant.OR); }
					case -13:
						break;
					case 13:
						{ return t (Constant.TIMES); }
					case -14:
						break;
					case 14:
						{ return t (Constant.DIVIDE); }
					case -15:
						break;
					case 15:
						{ return t (Constant.MOD); }
					case -16:
						break;
					case 16:
						{ return t (Constant.COMMA); }
					case -17:
						break;
					case 17:
						{ return t (Constant.LPAREN); }
					case -18:
						break;
					case 18:
						{ return t (Constant.RPAREN); }
					case -19:
						break;
					case 19:
						{ return t (Constant.DOT); }
					case -20:
						break;
					case 20:
						{ return t (Constant.LCURLY); }
					case -21:
						break;
					case 21:
						{ return t (Constant.RCURLY); }
					case -22:
						break;
					case 22:
						{ return t (Constant.LSQUARE); }
					case -23:
						break;
					case 23:
						{ return t (Constant.RSQUARE); }
					case -24:
						break;
					case 24:
						{ return t (Constant.COLON); }
					case -25:
						break;
					case 25:
						{ 
	System.err.println("Invalid character "+yytext()+" at line "+(yyline+1)+", attemping to continue");
	yybegin(YYINITIAL);
}
					case -26:
						break;
					case 26:
						{ 
	Integer newInt=null;
	try {
		newInt=new Integer(yytext());
	}
	catch (NumberFormatException e) {
		System.err.println("Invalid integer "+yytext()+" at line "+(yyline+1)+", attemping to continue");
	}	
	return t(Constant.INT_CONST, newInt); 
}
					case -27:
						break;
					case 27:
						{yybegin(STRINGS);}
					case -28:
						break;
					case 28:
						{ return t (Constant.IF); }
					case -29:
						break;
					case 29:
						{ return t (Constant.LEQ); /* Iota+ */ }
					case -30:
						break;
					case 30:
						{ return t (Constant.EQ); }
					case -31:
						break;
					case 31:
						{ return t (Constant.GEQ); /* Iota+ */ }
					case -32:
						break;
					case 32:
						{ return t (Constant.NEQ); /* Iota+ */ }
					case -33:
						break;
					case 33:
						{ return t (Constant.INCREMENT); /* Iota+ */ }
					case -34:
						break;
					case 34:
						{ return t (Constant.DECREMENT); /* Iota+ */ }
					case -35:
						break;
					case 35:
						{ yybegin (COMMENT); }
					case -36:
						break;
					case 36:
						{}
					case -37:
						break;
					case 37:
						{ return t (Constant.INT_TYPE); }
					case -38:
						break;
					case 38:
						{ return t (Constant.NEW); }
					case -39:
						break;
					case 39:
						{ return t (Constant.USES); }
					case -40:
						break;
					case 40:
						{ return t (Constant.ELSE); }
					case -41:
						break;
					case 41:
						{ return t (Constant.NULL_CONST); /* Iota+ */ }
					case -42:
						break;
					case 42:
						{ return t (Constant.TRUE_CONST, Boolean.TRUE); }
					case -43:
						break;
					case 43:
						{ return t (Constant.THIS); /* Iota+ */ }
					case -44:
						break;
					case 44:
						{ return t (Constant.BOOLEAN_TYPE); }
					case -45:
						break;
					case 45:
						{ return t (Constant.CAST); /* Iota+ */ }
					case -46:
						break;
					case 46:
						{ return t (Constant.BREAK); /* Iota+ */ }
					case -47:
						break;
					case 47:
						{ return t (Constant.ARRAY); }
					case -48:
						break;
					case 48:
						{ return t (Constant.CLASS); /* Iota+ */ }
					case -49:
						break;
					case 49:
						{ return t (Constant.FALSE_CONST, Boolean.FALSE); }
					case -50:
						break;
					case 50:
						{ return t (Constant.WHILE); }
					case -51:
						break;
					case 51:
						{return t(Constant.SEMIELSE);}
					case -52:
						break;
					case 52:
						{ return t (Constant.STRING_TYPE); }
					case -53:
						break;
					case 53:
						{ return t (Constant.RETURN); }
					case -54:
						break;
					case 54:
						{ return t (Constant.OBJECT_TYPE); /* Iota+ */ }
					case -55:
						break;
					case 55:
						{ return t (Constant.LENGTH); }
					case -56:
						break;
					case 56:
						{ return t (Constant.INTERFACE); /* Iota+ */ }
					case -57:
						break;
					case 57:
						{return t (Constant.IMPLEMENTS); /* Iota+ */}
					case -58:
						break;
					case 58:
						{
	System.err.println("Illegal comment on line "+(yyline+1)+", attemping to continue");
	yybegin(YYINITIAL);
}
					case -59:
						break;
					case 59:
						{yybegin (YYINITIAL);}
					case -60:
						break;
					case 60:
						{
	System.err.println("Unclosed string literal at line " +(yyline+1)+", attemping to continue");	
	yybegin(YYINITIAL);
}
					case -61:
						break;
					case 61:
						{ 
	yybegin(YYINITIAL);
	return t(Constant.STRING_CONST,interp_string(yytext().substring(0,yytext().length()-1)));
}
					case -62:
						break;
					case 62:
						{
	System.err.println("Illegal escape character at line " +(yyline+1)+", attemping to continue");
	yybegin(YYINITIAL);
}
					case -63:
						break;
					case 63:
						{
	System.err.println("Incorrect string literal at line " +(yyline+1)+", attemping to continue");
	yybegin(YYINITIAL);
}
					case -64:
						break;
					case 65:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -65:
						break;
					case 66:
						{ 
	Integer newInt=null;
	try {
		newInt=new Integer(yytext());
	}
	catch (NumberFormatException e) {
		System.err.println("Invalid integer "+yytext()+" at line "+(yyline+1)+", attemping to continue");
	}	
	return t(Constant.INT_CONST, newInt); 
}
					case -66:
						break;
					case 67:
						{
	System.err.println("Illegal comment on line "+(yyline+1)+", attemping to continue");
	yybegin(YYINITIAL);
}
					case -67:
						break;
					case 68:
						{
	System.err.println("Unclosed string literal at line " +(yyline+1)+", attemping to continue");	
	yybegin(YYINITIAL);
}
					case -68:
						break;
					case 70:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -69:
						break;
					case 72:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -70:
						break;
					case 74:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -71:
						break;
					case 76:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -72:
						break;
					case 78:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -73:
						break;
					case 80:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -74:
						break;
					case 82:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -75:
						break;
					case 84:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -76:
						break;
					case 86:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -77:
						break;
					case 88:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -78:
						break;
					case 90:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -79:
						break;
					case 91:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -80:
						break;
					case 92:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -81:
						break;
					case 93:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -82:
						break;
					case 94:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -83:
						break;
					case 95:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -84:
						break;
					case 96:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -85:
						break;
					case 97:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -86:
						break;
					case 98:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -87:
						break;
					case 99:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -88:
						break;
					case 100:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -89:
						break;
					case 101:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -90:
						break;
					case 102:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -91:
						break;
					case 103:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -92:
						break;
					case 104:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -93:
						break;
					case 105:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -94:
						break;
					case 106:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -95:
						break;
					case 107:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -96:
						break;
					case 108:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -97:
						break;
					case 109:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -98:
						break;
					case 110:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -99:
						break;
					case 111:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -100:
						break;
					case 112:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -101:
						break;
					case 113:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -102:
						break;
					case 114:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -103:
						break;
					case 115:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -104:
						break;
					case 116:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -105:
						break;
					case 117:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -106:
						break;
					case 118:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -107:
						break;
					case 119:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -108:
						break;
					case 120:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -109:
						break;
					case 121:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -110:
						break;
					case 122:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -111:
						break;
					case 123:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -112:
						break;
					case 124:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -113:
						break;
					case 125:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -114:
						break;
					case 126:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -115:
						break;
					case 127:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -116:
						break;
					case 128:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -117:
						break;
					case 129:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -118:
						break;
					case 130:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -119:
						break;
					case 131:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -120:
						break;
					case 132:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -121:
						break;
					case 133:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -122:
						break;
					case 134:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -123:
						break;
					case 135:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -124:
						break;
					case 136:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -125:
						break;
					case 137:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -126:
						break;
					case 138:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -127:
						break;
					case 139:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -128:
						break;
					case 140:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -129:
						break;
					case 141:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -130:
						break;
					case 142:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -131:
						break;
					case 143:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -132:
						break;
					case 144:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -133:
						break;
					case 145:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -134:
						break;
					case 146:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -135:
						break;
					case 147:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -136:
						break;
					case 148:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -137:
						break;
					case 149:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -138:
						break;
					case 150:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -139:
						break;
					case 151:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -140:
						break;
					case 152:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -141:
						break;
					case 153:
						{ return t (Constant.IDENTIFIER, yytext ().intern ()); }
					case -142:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
