package Iota;

import java.io.*;

public class LexTest {

    private static final String quietFlag = "-quiet";

	public static void main (String args[]) throws Exception {
		if (args.length < 1) {
			System.err.println
				("Usage: java Iota.LexTest [" + quietFlag + "] <filename>");
			System.exit (1);
		}

		boolean quiet = false;
		int i;
		for (i = 0; i < args.length; i++) {
			String filename = args[i];
			while (filename.charAt (0) == '-') {
				if (filename.equals (quietFlag)) {
					quiet = true;
					i++;
				}
				filename = args[i];
			}
			FileInputStream in=null;
			try {
				in = new FileInputStream (filename);
			}
			catch (IOException e) {
				System.err.println("File "+filename+" not found.");
				System.exit(-1);
			}
			Lexer lexer = new Lexer (in, filename);
			Token token=null;
			token = lexer.getToken ();
			while (token.getCode () != Constant.EOF) {
				if (!quiet) {
					token.unparse (System.out);
					System.out.println ("\t" + token.getID ());
				}
				token = lexer.getToken ();
			}
		}
	}
}
