/*
 *  io.c
 *  Cbasics
 *
 *  Created by Andrew Pershing on Tue Feb 26 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */
#include <stdio.h>
#include "io.h"
#include "system.h"

/* Prototypse for local functions.  These functions are only*/
/* called from within this file, so they shouldn't appear   */
/* in io.h to hide them from the user                       */
void CheckCase(int casenum, char *varname);
void GetSpaceTimeData(char filename[], int casenum, double ***val,
                    double **times, int m, int *N, double T);
                    
                    
                    
void ReadComm(char name[], int *m, double *L, double *dt, double *T,
            char Cfilename[],
            int *ucase, char ufilename[], int *kcase, char kfilename[],
            int *gcase, char gfilename[], int *Kcase, char Kfilename[] ){
    /* Opens the command file name and reads several parameters */
  FILE *COMMFIL;
  char msg[150], lin[150];
  
  COMMFIL=fopen(name, "r"); /* Opens file for reading (r) */
  if(COMMFIL==NULL){
    /* Unable to open file.  Return an error */
    sprintf(msg, "Unable to open commfile file: <%s>", name);
    Error("ReadComm",msg);
  }
  /* File is open, read each line */
  
  fgets(lin, 150, COMMFIL); /*copies line from COMMFIL into string lin */
  sscanf(lin, "%d", m);  /*extracts an integer (%d) and saves in m  */
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%lf", L);  /*extracts an double (%lf) and saves in L  */
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%lf", dt);  /*extracts an double (%lf) and saves in dt  */
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%lf", T);  /*extracts an double (%lf) and saves in T  */
  
  fgets(lin, 150, COMMFIL); 
  sscanf(lin,"%s",Cfilename);
  
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%d", ucase);  /*extracts ucase  */
  CheckCase(*ucase,"k");      /* Check that ucase =0,1,2 */
  fgets(lin, 256, COMMFIL); /* stores next line which is either a filename or value */
  sscanf(lin,"%s",ufilename);
  
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%d", kcase);  /*extracts kcase  */  
  CheckCase(*kcase,"k");      /* Check that kcase =0,1,2 */
  fgets(lin, 256, COMMFIL); /* stores next line which is either a filename or value */
  sscanf(lin,"%s",kfilename);

  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%d", gcase);  /*extracts gcase  */
  CheckCase(*gcase,"k");      /* Check that gcase =0,1,2 */
  fgets(lin, 256, COMMFIL); /* stores next line which is either a filename or value */
  sscanf(lin,"%s",gfilename);
  
  fgets(lin, 150, COMMFIL); 
  sscanf(lin, "%d", Kcase);  /*extracts Kcase  */
  CheckCase(*Kcase,"k");      /* Check that Kcase =0,1,2 */
  fgets(lin, 256, COMMFIL); /* stores next line which is either a filename or value */
  sscanf(lin,"%s",Kfilename);
  
  fclose(COMMFIL); /* closes the file */
}

void CheckCase(int casenum, char *varname){
    /* check that case is valid (0,1, or 2) */
    /* NOTE: this is only used inside io.c  */
    /* so it won't appear in io.h.  Thus,   */
    /* CheckCase is hidden from users of    */
    /* io.c                                 */ 
    char msg[256];
    if(casenum<0){
        sprintf(msg,"Invalid case (<0) for %s",varname);
        Error("ReadComm", msg);
    }else{
        if(casenum>2){
            sprintf(msg,"Invalid case (>2) for %s",varname);
            Error("ReadComm", msg);
        }
    }
}

void ReportParams(int m, double L, double dx,
                double dt, double T){
     /* Prints the Parameters */
    printf(" Your parameters are: \n\n");
    printf("          m=%d\n",m);
    printf("          L=%f\n",L);
    printf("         dx=%f\n",dx);
    printf("         dT=%f\n",dt);
    printf("          T=%f\n",T);
}

void GetInitialCond(char filename[], double *C, int m){
    /* Reads C from filenmae */
    FILE *FIL;
    char msg[150],lin[150];
    int j;
    /* First, open filename (return an error if needed) & get N */
    FIL=fopen(filename,"r");
    if(FIL==NULL){
        /* Unable to open file.  Return an error */
        sprintf(msg, "Unable to open file: %s", filename);
        Error("GetInitialCond",msg);
    }
    j=0;
    fgets(lin, 150, FIL); /* read a line */
    while(j<m && !feof(FIL)){
    	sscanf(lin, "%lf", &C[j]);  /* extracts N  */
        j=j+1;
        fgets(lin, 150, FIL);/* read next line */
    }
    if(j<m){
        sprintf(msg,"%s contains < m (%d) lines",filename,m);
        Error("GetInitialCond",msg);
    }
    if(!feof(FIL)){
        sprintf(msg,"%s contains > m (%d) lines",filename,m);
        Error("GetInitialCond",msg);
    }
}   
    void GetData(int kcase, char kfilename[], double ***k, double **ktimes, 
                int m, int *kN, double T, char descr[], char varname[]){
                
    double tmp;
    char msg[256];
    int j;
    
    printf("Getting %s data %s case=%d\n",descr, varname, kcase);
    if(kcase>0){
        /* read k from a file using GetSpaceTimeData */
        GetSpaceTimeData(kfilename, kcase, k, ktimes, m, kN, T);
        printf("Read %s successfully, found %d time levels\n",kfilename,*kN);
    } else {
        /*kfilename is the value of k, stored as a string */
        /*we can convert it to a double using SSCANF.     */
        /*The answer will be stored in tmp                */
        sscanf(kfilename,"%lf",&tmp);
        if(tmp<0){
            sprintf(msg, "%s must be >= 0",varname);
            Error("main",msg);
        }
            /*To simplify the programming, we'll store k as a */
            /*1-by-m array & copy the value throughout        */
        *kN=1;
        sprintf(msg, "Unable to create %s (2-by-%d)",varname,m);
        *k=new2Darray_double(*kN, m, "GetData", msg);
        sprintf(msg, "Unable to create %s (length %d)",varname,*kN);
        *ktimes=newarray_double(*kN, "GetData", msg);
        for(j=0;j<m;j++){
            (*k)[0][j]=tmp;
        }
        printf("Using constant %s=%f\n",varname, tmp);
    }
}


void GetSpaceTimeData(char filename[], int casenum, double ***val,
                    double **times, int m, int *N, double T){
    /* Reads data from filename.  Filename should have */
    /* the following format:                           */
    /*      line 1:  N --number of times               */   
    /*      line 2:  t1--first time level              */    
    /*      line 3:m+2:  values at first time level    */
    /*      repeat pattern in lines 2-3 N-1 more times */
    /* GetSpaceTimeData ensures that times is sorted   */
    /* and that times[0]<=0 & times[N-1]>T.  Also      */  
    /* double checks that if case==1 that N==1         */         
    
    /* This function is your job, but I'll show you a couple of things */
    FILE *FIL;
    char msg[150],lin[150];
    int i,j;
    double v;
    
    /* First, open filename (return an error if needed) & get N */
    FIL=fopen(filename,"r");
    if(FIL==NULL){
        /* Unable to open file.  Return an error */
        sprintf(msg, "Unable to open file: %s", filename);
        Error("GetSpaceTimeData",msg);
    }
    fgets(lin, 150, FIL);
    sscanf(lin, "%d", N);  /* extracts N  */

    if(casenum==1 && *N!=1){
        /* if case is 1, then N must be 1 */
        sprintf(msg, "file: %s. Case=1, but N=%d", filename, *N);
        Error("GetSpaceTimeData",msg);
    }



    /* This allocates space for val.  The extra * allows the subroutine */
    /* to change the value of val (in this case, the block of memory    */
    /* where it points) & have it the new value stick.  To use val      */
    /* in this routine, you will need the *.  In other words, to assign */
    /* a value, use                                                     */
    /*          (*val)[j][k]= <the value >;                             */
    *val=new2Darray_double(*N, m, "main", "Unable to create val (N-by-m)");
    *times=newarray_double(*N, "main", "Unable to create val (N-by-m)");
    for(i=0;i<*N;i++){
        if(feof(FIL)){
        /* Hit end of file.  Return an error */
            sprintf(msg, "EOF in %s at start of record %d out of %d", filename,i,*N);
            Error("GetSpaceTimeData",msg);
        }
        fgets(lin, 150, FIL);
        sscanf(lin, "%lf", &(*times)[i]);  /* extracts time  */
        /* Check that times is sorted */
        if(i>0){
        	if( (*times)[i]<=(*times)[i-1] ){
                	/* Hit end of file.  Return an error */
                	sprintf(msg, "times[%d]<=times[%d] in %s: times must be sorted",i,i-1, filename);
                	Error("GetSpaceTimeData",msg);
                }
        }
        for(j=0;j<m;j++){
        	if(feof(FIL)){
                	/* Hit end of file.  Return an error */
                	sprintf(msg, "EOF in %s at line %d of record %d", filename,j,i);
                	Error("GetSpaceTimeData",msg);
                }
            fgets(lin, 150, FIL);
            sscanf(lin, "%lf", &(*val)[i][j]);  /* extracts value  */
	}
    }

    fclose(FIL);

    if((*times)[0]>0 || (*times)[*N-1]<=T){
        /* if case is 1, then N must be 1 */
        sprintf(msg, "file: %s. Times does not span [0,T=%f]: times[0]=%f, times[N-1]=%f", 
        		filename, T,(*times)[0],(*times)[*N-1]);
        Error("GetSpaceTimeData",msg);
    }

}
void PrintArray(char name[], double C[], int m){
    /* Saves the length-m array C in a file called name */
    FILE *FIL;
    char msg[150];
    int j;
    
    FIL=fopen(name,"w");
    if(FIL==NULL){
        /* Unable to open file.  Return an error */
        sprintf(msg, "Unable to open file: %s", name);
        Error("PrintArray",msg);
    }
    for(j=0;j<m;j++){
        fprintf(FIL, "%f\n",C[j]);
    }
    fclose(FIL);
}



    
