/*
 *  system.h
 *  
 *  General purpose routines for system-level tasks
 *  such as error reporting and memory management
 *
 *  Created by Andrew Pershing on Tue Feb 26 2002.
 *
 */

#include <stdio.h>
#include <stdlib.h>


void Error(char *subrout, char *msg);
    /* Prints the error message in msg and exits */
    
int *newarray_int(int dim1, char *sub, char *msg);

double *newarray_double(int dim1, char *sub, char *msg);
    /* Allocates an array of dim1 doubles.  */
    /* If the system is unable to allocate, */
    /* then sub and msg are passed to error */

double **new2Darray_double(int dim1, int dim2, char *sub, char *msg);
    /* Allocates a dim1-by-dim2 array of doubles.  */
    /* If the system is unable to allocate,        */
    /* then sub and msg are passed to error        */
    
    
    